package com.yeejoin.amos.maintenance.common.enums;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author DELL
 * 维保任务排序
 */

public enum CheckRecordOrderByEnum {
    /**
     * 维保记录排序
     */
    DATE_DESC("维保记录时间倒序", "1", "checkDate desc"),
    DATE_ASC("维保记录时间正序", "2", "checkDate asc");

    /**
     * 名字
     */
    private String name;
    /**
     * 编号
     */
    private String code;

    /**
     * 条件
     */
    private String oderBy;

    public String getOderBy() {
        return oderBy;
    }

    public void setOderBy(String oderBy) {
        this.oderBy = oderBy;
    }

    CheckRecordOrderByEnum(String name, String code, String oderBy) {
        this.code = code;
        this.name = name;
        this.oderBy = oderBy;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static List<Map<String, Object>> getEnumList() {
        return Arrays.stream(CheckRecordOrderByEnum.values()).map(e -> {
            Map<String, Object> map = new HashMap<>();
            map.put(e.getCode(), e.getName());
            return map;
        }).collect(Collectors.toList());
    }

    public static CheckRecordOrderByEnum getEumByCode(String code) throws Exception {
        Optional<CheckRecordOrderByEnum> op = Arrays.stream(CheckRecordOrderByEnum.values()).filter(e->e.getCode().equals(code)).findFirst();
        return op.orElseThrow(()->new Exception("非法的条件"));
    }

}
