package com.yeejoin.amos.api.householdapi.Utils;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.api.householdapi.constant.GoLangConstant;
import com.yeejoin.amos.api.householdapi.constant.KSolarConstant;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.houseapi.HousepvapiRecords;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.houseapi.HousepvapiRecordsMapper;
import com.yeejoin.amos.openapi.enums.PVProducerInfoEnum;
import lombok.extern.slf4j.Slf4j;
import org.bouncycastle.jcajce.provider.symmetric.AES;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.nio.charset.StandardCharsets;
import java.util.*;

@Component
@Slf4j
public class KsolarRequestUtil {

    @Autowired
    HousepvapiRecordsMapper housepvapiRecordsMapper;

    /**
     * @return HashMap<String, Object>   发送请求前的准备 准备header信息
     * @deprecated 根据厂商编码获取厂商的hearer
     */
    public HashMap<String, String> getHeader() {
        HashMap<String, String> hashMap = new HashMap<>();
        String requestParam="";
        HashMap<String, String> hashMaphead = new HashMap<>();
        try {
             requestParam = "username="+KSolarConstant.account+"&password="+AESUtils.Encrypt(KSolarConstant.password, AESUtils.DEFAULT_SECRET_KEY);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        String url = KSolarConstant.baseurl + KSolarConstant.tokenUrl;
        hashMaphead.put("Content-Type","application/x-www-form-urlencoded;charset=utf-8");
        hashMaphead.put("Authorization", "Basic " + Base64.getUrlEncoder().encodeToString((KSolarConstant.authUsername + ":" + KSolarConstant.authPassword).getBytes(StandardCharsets.UTF_8)));
        String ResPonse = HttpUtil.createPost(url).headerMap(hashMaphead, false).body(requestParam).execute().body();
        JSONObject jsonObject = JSONObject.parseObject(ResPonse);
        jsonObject = (JSONObject) jsonObject.get("token");
        String token= (String) jsonObject.get("access_token");
        hashMap.put("Authorization", "Bearer "+ token);
        return hashMap;
    }

    /**
     * @param apiurl            请求url
     * @param requestMethod     请求方式
     * @param requestParmInfo   请求参数mapper
     * @param ResultResolveRule 请求的解析
     * @param tClass            需要转换成的bean
     * @param <T>               泛型数据
     * @return List<T> list<Result>
     * @desc 根据请求参数发送http请求并且对于返回的数据进行处理
     */
    public <T> List<T> getResPonse(String apiurl, String requestMethod, String requestParmInfo, String ResultResolveRule, Class<T> tClass) {
        String respone = "";
        String params = "";
        JSONArray jsonArray = null;
        List<T> result = new ArrayList<>();
        try {
            HashMap<String, String> headMap = getHeader();
            String url = KSolarConstant.baseurl + apiurl;
            respone = sendRequest(requestMethod, url, requestParmInfo, headMap);
            jsonArray = handlerResponseByResultResolverule(ResultResolveRule, respone);
            log.info("原始数据：{}", jsonArray);
            if (!ObjectUtils.isEmpty(jsonArray)) {
                result = JSONArray.parseArray(jsonArray.toJSONString(), tClass);
            }
        } catch (Exception exception) {
            return result;
        }
        return result;
    }

    /**
     * @param resultResovle 请求返回的解析规则 来源与数据库
     * @param response      请求返回的字符串
     * @return 解析后的数据
     * @desc 根据解析规则解析请求返回数据
     */
    public JSONArray handlerResponseByResultResolverule(String resultResovle, String response) {
        JSONArray jsonArray = new JSONArray();

        if ("arr".equals(resultResovle)) {
            jsonArray = JSONArray.parseArray(response);
        } else {
            JSONObject jsonObject = JSONObject.parseObject(response);
            if (ObjectUtil.isNotEmpty(resultResovle)) {
                String[] rules = resultResovle.split(",");
                if (rules.length > 0) {
                    for (int i = 0; i < rules.length; i++) {
                        try {
                            jsonObject = (JSONObject) jsonObject.get(rules[i]);
                            if (jsonObject == null) {
                                jsonArray = (JSONArray) jsonObject.get(rules[i]);
                            }
                        } catch (Exception exception) {
                            jsonArray = (JSONArray) jsonObject.get(rules[i]);
                        }
                    }
                }
                if (jsonArray.size() == 0) {
                    jsonArray.add(jsonObject);
                }
            }
        }
        return jsonArray;
    }

    public String sendRequest(String requestMethod, String url, String params, HashMap<String, String> headMap) {
        HousepvapiRecords housepvapiRecords = new HousepvapiRecords();
        housepvapiRecords.setRecDate(new Date());
        housepvapiRecords.setRequestUrl(url);
        housepvapiRecords.setRequestMothed(requestMethod);
        housepvapiRecords.setRequestHeaders(JSONObject.toJSONString(headMap));
        housepvapiRecords.setRequestParams(params);
        housepvapiRecords.setThridCode(PVProducerInfoEnum.KSOLAR.getCode());
        String respone = "";
        if (requestMethod.equals("POST")) {
            respone = HttpUtil.createPost(url).headerMap(headMap, false).
                    body(params).execute().body();
        }
        if (requestMethod.equals("GET")) {
            respone = HttpUtil.createGet(url).headerMap(headMap, true).
                    body(params).execute().body();
        }
        housepvapiRecords.setResponse(respone);
        housepvapiRecordsMapper.insert(housepvapiRecords);
        log.info("科士达数据请求详情："+JSONObject.toJSONString(housepvapiRecords));
        return respone;
    }

    /***
     *
     * @param params 参数字符窜
     * @param headMap header头
     * @param orginalAuthorization 原始的orginalAuthorization
     * @param appsecret  appsecret
     * @desc 锦浪云请求参数及head头处理
     */
    public void JLYHeaderMapHandler(String params, HashMap<String, String> headMap, String orginalAuthorization, String appsecret, String apiurl) {
        String contentMD5 = GoLangHeaderUtils.getDigest(params);
        headMap.put("Date", GoLangHeaderUtils.getGMTTime());
        String param = "POST" + "\n" + contentMD5 + "\n" + "application/json" + "\n" + headMap.get("Date") + "\n" + apiurl;
        String sign = "";
        try {
            sign = GoLangHeaderUtils.HmacSHA1Encrypt(param, appsecret);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        headMap.put("Content-MD5", contentMD5);
        headMap.put("Authorization", orginalAuthorization + sign);
    }

    /**
     * @param pageSizeResovle
     * @param response
     * @return
     * @desc 根据分页规则 获取分页数
     */
    public Integer getPagesize(String pageSizeResovle, String response) {
        Integer pageSize = 0;
        String[] rules = pageSizeResovle.split(",");
        JSONObject jsonObject = JSONObject.parseObject(response);
        if (rules.length > 0) {
            for (int i = 0; i < rules.length - 1; i++) {
                jsonObject = (JSONObject) jsonObject.get(rules[i]);
            }
        }
        pageSize = (Integer) jsonObject.get(rules[rules.length - 1]);
        return pageSize;
    }
}
