package com.yeejoin.amos.api.openapi.face.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import com.yeejoin.amos.api.openapi.face.model.AbstractBaseModel;
/**
 * 安全追溯-索道
 *
 * @author cpp
 * @date 2023-04-06 15:21:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="MidEquipTechParamRopewayDto", description="安全追溯-索道Dto")
public class EquipTechParamRopewayModel extends AbstractBaseModel {
    private static final long serialVersionUID = 1L;


            @ApiModelProperty(value = "监管码")
        private String supervisoryCode;

            @ApiModelProperty(value = "$column.comments")
        private String instanceId;
            @ApiModelProperty(value = "$column.comments")
        private String status;
            @ApiModelProperty(value = "$column.comments")
        private BigDecimal horizontalDistance;
            @ApiModelProperty(value = "支架数目")
        private Integer supportsCount;
            @ApiModelProperty(value = "斜长")
        private BigDecimal obliqueLength;
            @ApiModelProperty(value = "主电机型号和功率")
        private BigDecimal mainMotorModelAndPower;
            @ApiModelProperty(value = "高差")
        private BigDecimal altitudeDifference;
            @ApiModelProperty(value = "张紧油压（重锤）")
        private BigDecimal oilPressureHeavyHammer;
            @ApiModelProperty(value = "张紧油压（油压）")
        private BigDecimal oilPressureOilPressure;
            @ApiModelProperty(value = "运量")
        private BigDecimal freightVolume;
            @ApiModelProperty(value = "运载索")
        private String carrierLine;
            @ApiModelProperty(value = "速度")
        private BigDecimal speed;
            @ApiModelProperty(value = "承载索")
        private String bearingCable;
            @ApiModelProperty(value = "索距")
        private BigDecimal cablePitch;
            @ApiModelProperty(value = "运载工具数量和类型")
        private String numberAndTypeOfVehicles;
            @ApiModelProperty(value = "索引索")
        private String tractionRope;
            @ApiModelProperty(value = "平衡索")
        private String balanceCable;

            @ApiModelProperty(value = "主要部件")
        private String mainComponents;

    
}
