package com.yeejoin.amos.boot.module.ccs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 消防系统信息
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("ast_fire_fighting_system")
public class FireFightingSystem extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 站点名称
     */
    @TableField("station_name")
    private String stationName;

    /**
     * 站点编码
     */
    @TableField("station_code")
    private String stationCode;

    /**
     * 名称
     */
    @TableField("name")
    private String name;

    /**
     * 资产id
     */
    @TableField("mrid")
    private String mrid;

    /**
     * 安装日期
     */
    @TableField("install_date")
    private String installDate;

    /**
     * 负责人
     */
    @TableField("charge_person")
    private String chargePerson;

    /**
     * 负责人电话
     */
    @TableField("charge_person_phone")
    private String chargePersonPhone;

    /**
     * 施工单位
     */
    @TableField("construction_unit")
    private String constructionUnit;

    /**
     * 维保单位
     */
    @TableField("maintenance_unit")
    private String maintenanceUnit;

    /**
     * 首次维保日期
     */
    @TableField("first_maintenance_date")
    private Date firstMaintenanceDate;

    /**
     * 维保频率
     */
    @TableField("maintenance_frequency")
    private String maintenanceFrequency;

    /**
     * 维保电话
     */
    @TableField("maintenance_phone")
    private String maintenancePhone;

    /**
     * 修改时间
     */
    @TableField("update_date")
    private Date updateDate;

    /**
     * 经度
     */
    @TableField("lng")
    private String lng;

    /**
     * 纬度
     */
    @TableField("lat")
    private String lat;

}
