package com.yeejoin.equipmanage.common.datasync.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @ProjectName: YeeFireDataProcessRoot
 * @Package: com.yeejoin.dataprocess.common.vo
 * @ClassName: AppAlarmListVo
 * @Author: Jianqiang Gao
 * @Description: AppAlarmListVo
 * @Date: 2021/4/23 15:30
 * @Version: 1.0
 */
@Data
@ApiModel(value = "AppAlarmList对象", description = "故障告警表")
public class AppAlarmVo {

    @ApiModelProperty(value = "告警时间")
    private String time = "";

    @ApiModelProperty(value = "区域ID")
    private String areaid = "";

    @ApiModelProperty(value = "区域名称")
    private String areaname = "";

    @ApiModelProperty(value = "电站ID")
    private String stationid = "";

    @ApiModelProperty(value = "电站名称")
    private String stationname = "";

    @ApiModelProperty(value = "设备ID")
    private String deviceid = "";

    @ApiModelProperty(value = "设备名称")
    private String devicename = "";

    @ApiModelProperty(value = "部件ID")
    private String partid = "";

    @ApiModelProperty(value = "部件名称")
    private String partname = "";

    @ApiModelProperty(value = "子类型")
    private String type = "";

    @ApiModelProperty(value = "等级")
    private Integer eventlevel = 1;

    @ApiModelProperty(value = "事件描述")
    private String eventdesc = "";

    @ApiModelProperty(value = "动作名称")
    private String eventaction = "";

    @ApiModelProperty(value = "是否拥有简报")
    private Boolean isreport = false;
}