package com.yeejoin.equipmanage.common.entity.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author ZeHua Li
 * @date 2020/11/16 18:21
 * @since v2.0
 */
@Data
@ApiModel(value = "VideoListVo", description = "")
public class VideoListVo extends BaseEntity {

    @ApiModelProperty(value = "摄像机编号")
    @TableField(value = "code")
    private String code;

    @ApiModelProperty(value = "类型")
    @TableField(value = "type")
    private String type;

    @ApiModelProperty(value = "ip")
    @TableField(value = "ip")
    private String ip;

    @ApiModelProperty(value = "用户名")
    @TableField(value = "account")
    private String account;

    @ApiModelProperty(value = "密码")
    @TableField(value = "password")
    private String password;

    @ApiModelProperty(value = "端口号")
    @TableField(value = "port")
    private String port;

    @ApiModelProperty(value = "通道")
    @TableField(value = "tube")
    private String tube;

    @ApiModelProperty(value = "创建人ID")
    @TableField(value = "creator_id")
    private Long creatorId;

    @ApiModelProperty(value = "创建人名")
    @TableField(value = "creator_name")
    private String creatorName;

    @ApiModelProperty(value = "公司名称")
    @TableField(value = "company_name")
    private String companyName;

    @ApiModelProperty(value = "公司code")
    @TableField(value = "org_code")
    private String orgCode;

    @ApiModelProperty(value = "部门名称")
    @TableField(value = "department_name")
    private String departmentName;

    @ApiModelProperty(value = "部门code")
    @TableField(value = "department_orgcode")
    private String departmentOrgcode;

    @ApiModelProperty(value = "视频rtsp")
    @TableField(value = "rtsp_address")
    private String rtspAddress;

    @ApiModelProperty(value = "访问url")
    @TableField(value = "url")
    private String url;

    @ApiModelProperty(value = "型号")
    @TableField(value = "carmera_type")
    private String carmeraType;

    @ApiModelProperty(value = "三维坐标信息：{\\\"x\\\":168.4586,\\\"y\\\":1.1004,\\\"z\\\":30.3959}")
    @TableField(value = "position3d")
    private String position3d;

    @ApiModelProperty(value = "摄像头唯一token")
    @TableField(value = "token")
    private String token;

    @ApiModelProperty(value = "摄像机名称")
    @TableField(value = "name")
    private String name;

    @ApiModelProperty(value = "备注")
    @TableField(value = "remark")
    private String remark;

    @ApiModelProperty(value = "图片")
    @TableField(value = "img")
    private String img;

    @ApiModelProperty(value = "详细地址")
    @TableField(value = "address")
    private String address;


    @ApiModelProperty(value = "经度")
    @TableField(value = "longitude")
    private Double longitude;


    @ApiModelProperty(value = "纬度")
    @TableField(value = "latitude")
    private Double latitude;



    @ApiModelProperty(value = "预置位")
    @TableField(value = "preset_position")
    private String presetPosition;

    @ApiModelProperty(value = "距离")
    private Double distance;

    @ApiModelProperty(value = "状态")
    private boolean status;
}
