package com.yeejoin.equipmanage.common.response;

import com.yeejoin.equipmanage.common.constant.Constant;

/**
 * @ProjectName: EquipManageRoot
 * @Package: com.yeejoin.equipmanage.common.response
 * @ClassName: Common3dResponseUtil
 * @Author: Jianqiang Gao
 * @Description: Common3dResponseUtil
 * @Date: 2021/6/3 11:11
 * @Version: 1.0
 */
public class Common3dResponseUtil {
    public static Common3dResponse success()
    {
        Common3dResponse response = new Common3dResponse();
        response.setId(1);
        response.setCode("47100");
        response.setMessage(Constant.RESULT_SUCCESS);
        return response;
    }

    public static Common3dResponse success(Object obj)
    {
        Common3dResponse response = new Common3dResponse();
        response.setId(1);
        response.setCode("47100");
        response.setMessage(Constant.RESULT_SUCCESS);
        response.setBody(obj);
        return response;
    }

    public static Common3dResponse success(Object obj, String message)
    {
        Common3dResponse response = new Common3dResponse();
        response.setId(1);
        response.setCode("47100");
        response.setBody(obj);
        response.setMessage(message);
        return response;
    }

    public static Common3dResponse failure()
    {
        Common3dResponse response = new Common3dResponse();
        response.setId(0);
        response.setCode("47100");
        response.setMessage(Constant.RESULT_FAILURE);
        return response;
    }

    public static Common3dResponse failure(String message)
    {
        Common3dResponse response = new Common3dResponse();
        response.setId(0);
        response.setCode("47100");
        response.setMessage(message);
        return response;
    }

    public static Common3dResponse failure(Object obj, String message)
    {
        Common3dResponse response = new Common3dResponse();
        response.setId(0);
        response.setCode("47100");
        response.setBody(obj);
        response.setMessage(message);
        return response;
    }
}