package com.yeejoin.amos.kgd.service;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import com.yeejoin.amos.component.feign.model.Page;
import com.yeejoin.amos.component.influxdb.InfluxDbConnection;
import com.yeejoin.amos.component.influxdb.InfluxdbUtil;
import com.yeejoin.amos.kgd.message.Constant;

import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheObject;

@Component
public class LiveDataService {
    private final Logger logger = LogManager.getLogger(LiveDataService.class);
    @Autowired
    private InfluxdbUtil influxdbUtil;

    @Autowired
    InfluxDbConnection influxDbConnection;
    
	@Autowired
	private CacheChannel cacheChannel;

    public static final String SPACE = " ";
    public static final String ASTERISK = "*";
    public static final String DATE = "time";
    public static final String COMMA = ",";
    public static final String FROM = "FROM";
    public static final String WHERE = "WHERE";
    public static final String EQUALSIGN = "=";
    public static final String AND = "AND";

    public List queryHistoryDataForList(String tableName,  String  timeStart, String timeEnd, String fieldKeys, Map<String, Object> requestParams) {
    	StringBuffer sqlSb = new StringBuffer();
    	sqlSb.append("SELECT").append(SPACE);
    	if (ObjectUtils.isEmpty(fieldKeys)) {
    		sqlSb.append(SPACE).append(ASTERISK).append(SPACE);
    	} else {
    		fieldKeys = fieldKeys + ", createdTime ";
    		sqlSb.append(SPACE).append(fieldKeys).append(SPACE);
    	}
    	sqlSb.append(SPACE).append(FROM).append(SPACE);
    	sqlSb.append(tableName);
    	if (!ObjectUtils.isEmpty(requestParams)) {
    		sqlSb.append(SPACE).append(WHERE).append(SPACE);
    		sqlSb.append(DATE).append(">=").append("'").append(timeStart).append("'");
    		sqlSb.append(AND).append(DATE).append("<=").append("'").append(timeEnd).append("'");
    		Set<String> keys = requestParams.keySet();

    		StringBuffer whereSb = new StringBuffer();
    		for (String key : keys) {
    			whereSb.append(AND).append(SPACE).append(key).append(SPACE).append(EQUALSIGN).append(requestParams.get(key)).append(SPACE);
    		}
    		sqlSb.append(whereSb.toString());
    	}
    	sqlSb.append(SPACE).append("tz('Asia/Shanghai')");

    	List<Map<String, Object>> list = influxdbUtil.query(sqlSb.toString());
        return list;
    }
    
    

    public Page<Map<String, Object>> queryHistoryDataForPage(String tableName,  String  timeStart, String timeEnd, String fieldKeys, Map<String, Object> requestParams, long current, long size) {
    	StringBuffer sqlSb = new StringBuffer();
    	StringBuffer countSb = new StringBuffer();
    	StringBuffer whereSb = new StringBuffer();
    	sqlSb.append("SELECT").append(SPACE);
    	if (ObjectUtils.isEmpty(fieldKeys)) {
    		sqlSb.append(SPACE).append(ASTERISK).append(SPACE);
    	} else {
    		fieldKeys = fieldKeys + ", createdTime ";
    		sqlSb.append(SPACE).append(fieldKeys).append(SPACE);
    	}
    	sqlSb.append(SPACE).append(FROM).append(SPACE);
    	sqlSb.append(tableName);
    	if (!ObjectUtils.isEmpty(requestParams)) {
    		whereSb.append(SPACE).append(WHERE).append(SPACE);
    		whereSb.append(DATE).append(">=").append("'").append(timeStart).append("'").append(SPACE);
    		whereSb.append(AND).append(SPACE).append(DATE).append("<=").append("'").append(timeEnd).append("'");
    		Set<String> keys = requestParams.keySet();

    		StringBuffer subWhereSb = new StringBuffer();
    		for (String key : keys) {
    			subWhereSb.append(AND).append(SPACE).append(key).append(SPACE).append(EQUALSIGN).append(requestParams.get(key)).append(SPACE);
    		}
    		whereSb.append(subWhereSb.toString());
    	}
    	
    	sqlSb.append(" LIMIT  ").append(size).append(" OFFSET ").append((current - 1) * size);
    	sqlSb.append(whereSb.toString());
    	sqlSb.append(SPACE).append("tz('Asia/Shanghai')");
 
    	
    	
    	countSb.append("SELECT COUNT(createdTime) FROM ").append(tableName);
    	countSb.append(whereSb.toString());
    	
    	List<Map<String, Object>> count = influxdbUtil.query(countSb.toString());
    	
    	
    	List<Map<String, Object>> list = influxdbUtil.query(sqlSb.toString());
    	
    	Page<Map<String, Object>> page = new Page<Map<String, Object>>();
		page.setCurrent(current);
		page.setSize(size);
		page.setRecords(list);
		page.setTotal((Double.valueOf(count.get(0).get("count").toString()).longValue()));
        return page;
    }
    
    
    public Map<String, Object> queryrealTimeData(String tableName) {
    	CacheObject cacheObject = cacheChannel.get(Constant.REGION, tableName);
    	return (Map<String, Object>) cacheObject.getValue();
    }
}
