package com.yeejoin.equipmanage.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.equipmanage.common.entity.StockBill;
import com.yeejoin.equipmanage.common.entity.dto.StockBillDTO;
import com.yeejoin.equipmanage.common.entity.dto.StockBillDetailDTO;
import com.yeejoin.equipmanage.common.entity.vo.StockBillDetailVO;
import com.yeejoin.equipmanage.service.IStockBillDetailService;
import com.yeejoin.equipmanage.service.IStockBillService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;


/**
 * @author wujiang
 * @date 2020-07-07
 */
@RestController
@Api(tags = "库存单据Api")
@RequestMapping(value = "/stock-bill", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class StockBillController {

    @Autowired
    IStockBillService stockBillService;
    @Autowired
    IStockBillDetailService stockBillDetailService;

    /**
     * 新增
     *
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public boolean saveStockBill(@RequestBody StockBill stockBill) {
        return stockBillService.save(stockBill);
    }

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
        return stockBillService.removeById(id);
    }


    /**
     * 修改
     *
     * @return
     */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
    public boolean updateByIdStockBill(HttpServletRequest request, @RequestBody StockBill stockBill) {
        return stockBillService.updateById(stockBill);
    }


    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public StockBill selectById(HttpServletRequest request, @PathVariable Long id) {
        return stockBillService.getById(id);
    }


    /**
     * 列表分页查询
     *
     * @return
     */
    @PostMapping(value = "/list")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "列表分页查询", notes = "列表分页查询")
    public IPage<StockBill> listPage(@RequestBody StockBillDTO stockBillDTO) {
        return stockBillService.selectAllBill(stockBillDTO.getPage(), stockBillDTO);
    }

    /**
     * 列表分页查询
     *
     * @returndetail
     */
    @PostMapping(value = "/detail")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "单据详情", notes = "单据详情")
    public IPage<StockBillDetailVO> detailPage(@RequestBody StockBillDetailDTO stockBillDetail) {
        return stockBillDetailService.selectStockBillDetailPage(stockBillDetail.getPage(),Long.valueOf(stockBillDetail.getId()),stockBillDetail.getEquipmentName(),stockBillDetail.getManufacturerName(),stockBillDetail.getEquipmentTypeName(),stockBillDetail.getType());
    }

    /**
     * 打印列表
     *
     * @returndetail
     */
    @PostMapping(value = "/detailList")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "单据详情", notes = "单据详情")
    public List<StockBillDetailVO> detail(@RequestBody StockBillDetailDTO stockBillDetail) {
        return stockBillDetailService.selectStockBillDetailList(Long.valueOf(stockBillDetail.getId()),stockBillDetail.getType());
    }


}


