package com.yeejoin.equipmanage.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Component;

import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.MonitorViewVideo;
import com.yeejoin.equipmanage.common.entity.dto.MonitorViewVideoDto;
import com.yeejoin.equipmanage.mapper.MonitorViewVideoMapper;

/**
 * 
 * <pre>
 * 在岗监测视图与视频关系表  服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: MonitorViewVideoService.java, v 0.1 2021年9月10日 下午7:31:08 gwb
 *          Exp $
 */
@Component
public class MonitorViewVideoService extends
		BaseService<MonitorViewVideoDto, MonitorViewVideo, MonitorViewVideoMapper>
{

	
	 @Autowired
	 private MonitorViewVideoMapper monitorViewVideoMapper;


	
	/**
	 * 
	 * <pre>
	 * 删除视图关联的视频
	 * </pre>
	 *
	 * @param viewId
	 */
	public void deleteMonitorViewVideo(Long viewId)
	{
		monitorViewVideoMapper.deleteMonitorViewVideo(viewId);
	}
	
	/**
	 * 
	 * <pre>
	 * 查询所有数据
	 * </pre>
	 *
	 * @return
	 */
	public List<MonitorViewVideoDto> queryAllForList()
	{
		return this.queryForList("", false);
	}
	
	public List<MonitorViewVideoDto> queryForListByViewId(Long viewId)
	{
		return this.queryForList("", false, viewId);
	}
	
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public Page<MonitorViewVideoDto> queryForPage(Page page, Long viewId)
	{
		return this.queryForPage(page, null, false, viewId);
	}
}
