package com.yeejoin.equipmanage.service.impl;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.equipmanage.common.entity.StockBillDetail;
import com.yeejoin.equipmanage.common.entity.vo.StockBillDetailVO;
import com.yeejoin.equipmanage.mapper.StockBillDetailMapper;
import com.yeejoin.equipmanage.service.IStockBillDetailService;

/**
 *  服务实现类
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Service
public class StockBillDetailServiceImpl extends ServiceImpl<StockBillDetailMapper, StockBillDetail> implements IStockBillDetailService {

    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    protected HttpServletRequest request;

    @Override
    public List<StockBillDetailVO> selectStockBillDetailList(Long id,String type) {
        //获取用户信息
        ReginParams user = getSelectedOrgInfo();
        //拼接单位名称
        List<StockBillDetailVO> list = this.baseMapper.selectStockBillDetailList(id,type);
        list.forEach(x->{
            x.setOrgCode(user.getCompany().getCompanyName());

        });
        return list;
    }

    @Override
    public IPage<StockBillDetailVO> selectStockBillDetailPage(IPage<StockBillDetail> page, Long id,String equipmentName,String manufacturerName,String equipmentTypeName,String type) {
        //获取用户信息
        ReginParams user = getSelectedOrgInfo();
        //拼接单位名称
        IPage<StockBillDetailVO> pages = this.baseMapper.selectStockBillDetailPage(page,type,id,equipmentName,manufacturerName,equipmentTypeName);
            pages.getRecords().forEach(x->{
                if(x!=null){
                    if(user.getCompany()!=null){
                        x.setOrgCode(user.getCompany().getCompanyName());
                    }
                }
            });

        return pages;
    }

    /**
     * 当前登录用户信息
     */
    @Override
    public ReginParams getSelectedOrgInfo() {
        return JSONObject.parseObject(redisUtils.get(buildKey(getUserId(), getToken())).toString(), ReginParams.class);
    }

    protected String getToken() {
        String authToken = request.getHeader("token");
        if (authToken == null) {
            authToken = request.getHeader("X-Access-Token");
        }
        return authToken;
    }

    /**
     * 当前登录用户信息
     */
    protected AgencyUserModel getUserInfo() {
        AgencyUserModel userModel = null;
        if (getToken() != null) {
            RequestContext.setToken(getToken());
            RequestContext.setProduct(getProduct());
            RequestContext.setAppKey(getAppKey());
            FeignClientResult<?> feignClientResult;
            try {
                feignClientResult = Privilege.agencyUserClient.getme();
                userModel = (AgencyUserModel) feignClientResult.getResult();

            } catch (InnerInvokException e) {
                throw new RuntimeException(e.getMessage());
            }

        }
        return userModel;

    }

    protected String getUserId() {
        String userId = null;
        if (getUserInfo() != null) {
            userId = getUserInfo().getUserId();
        }
        return userId;
    }

    protected String getProduct() {
        String authToken = request.getHeader("product");
        if (authToken == null) {
            authToken = request.getParameter("product");
        }
        return authToken;
    }

    protected String getAppKey() {
        String authToken = request.getHeader("appKey");
        if (authToken == null) {
            authToken = request.getParameter("appKey");
        }
        return authToken;
    }
    // redi缓存选择的用户信息
    private String buildKey(String userId, String token) {
    	 return RedisKey.buildReginKey(userId, token);
    }

}
