package com.yeejoin.amos.fas.business.feign;


import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.yeejoin.amos.boot.biz.common.feign.FeignConfiguration;
import com.yeejoin.amos.fas.core.util.CommonResponse;

@FeignClient(name="${visual.fegin.name}", fallback=MassVisualFallback.class, configuration=FeignConfiguration.class)
public interface IMaasVisualServer {
	@RequestMapping(value = "/tree/subject/findAll", method = RequestMethod.GET)
	public CommonResponse getTree();

	@RequestMapping(value = "/subject/list/{subjectId}", method = RequestMethod.GET)
	public CommonResponse getSubjectById(@PathVariable("subjectId")  String subjectId);
}
