package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 验收整改单
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_acceptance_rectification_order")
public class RectificationOrder extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 整改单号
     */
    @TableField("rectification_order_code")
    private String rectificationOrderCode;

    /**
     * 施工单ID
     */
    @TableField("work_order_id")
    private Long workOrderId;

    /**
     * 施工电站ID
     */
    @TableField("work_order_power_station_id")
    private Long workOrderPowerStationId;

    /**
     * 农户ID
     */
    @TableField("peasant_household_id")
    private Long peasantHouseholdId;

    /**
     * 电站ID
     */
    @TableField("power_station_id")
    private String powerStationId;

    /**
     * 问题描述
     */
    @TableField("problem_description")
    private String problemDescription;

    /**
     * 整改结果
     */
    @TableField("rectification_result")
    private String rectificationResult;

    /**
     * 整改描述
     */
    @TableField("rectification_description")
    private String rectificationDescription;

    /**
     * 完成日期
     */
    @TableField("complete_date")
    private String completeDate;

    /**
     * 负责人ID
     */
    @TableField("responsible_user_id")
    private String responsibleUserId;

    /**
     * 负责人姓名
     */
    @TableField("responsible_user_name")
    private String responsibleUserName;

    /**
     * 负责人电话
     */
    @TableField("responsible_user_phone")
    private String responsibleUserPhone;

    /**
     * 整改照片
     */
    @TableField("rectification_photo")
    private String rectificationPhoto;
}
