package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.entity.PersonContractAttachment;
import com.yeejoin.precontrol.common.mapper.PersonContractAttachmentMapper;
import com.yeejoin.precontrol.common.service.IPersonContractAttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 人员合同信息附件 服务实现类
 *
 * @author sqy
 * @date 2020-06-30
 */
@Service
public class PersonContractAttachmentServiceImpl extends ServiceImpl<PersonContractAttachmentMapper, PersonContractAttachment> implements IPersonContractAttachmentService {
    @Autowired
    PersonContractAttachmentMapper contractAttachMapper;
    @Value("${fileserver.domain}")
    String fileServerUrl;

    @Override
    public void saveAttach(Long id, List<PersonContractAttachment> attachment) {
        HashMap<String, Object> filter = new HashMap<>();
        filter.put("person_contract_id", id);
        List<PersonContractAttachment> oldAttachs = contractAttachMapper.selectByMap(filter);
        List<Long> oldIdList = oldAttachs.stream().map(PersonContractAttachment::getId).collect(Collectors.toList());
        if (oldIdList.size() > 0) {
            contractAttachMapper.deleteBatchIds(oldIdList);
        }
        if (attachment != null) {
            attachment.forEach(a -> {
                a.setPersonContractId(id);
                if (a.getAttachment() != null) {
                    a.setAttachment(a.getAttachment().replace(fileServerUrl, ""));
                }
                contractAttachMapper.insert(a);
            });
        }
    }
}
