package com.yeejoin.precontrol.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.StudioPageableDto;
import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.entity.Retribution;
import com.yeejoin.precontrol.common.service.IRetributionService;
import com.yeejoin.precontrol.common.utils.Response;
import com.yeejoin.precontrol.common.utils.StringUtil;
import com.yeejoin.precontrol.common.vo.RetributionVo;
import com.yeejoin.precontrol.common.vo.RewardListVo;
import com.yeejoin.precontrol.common.vo.RewardOrgCodeVo;
import com.yeejoin.precontrol.controller.publics.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 惩罚表
 *
 * @author duanwei
 * @date 2021-04-06
 */
@RestController
@Api(tags = "惩罚表Api")
@RequestMapping(value = "/retribution", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class RetributionController extends BaseController {

	@Autowired
	IRetributionService iRetributionService;

	/**
	 * 新增惩罚表
	 *
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "新增惩罚表", notes = "新增惩罚表")
	public boolean saveRetribution(HttpServletRequest request, @RequestBody Retribution retribution) {
		return iRetributionService.save(retribution);
	}

	/**
	 * 根据id删除
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
		return iRetributionService.removeById(id);
	}

	/**
	 * 修改惩罚表
	 *
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@ApiOperation(httpMethod = "PUT", value = "修改惩罚表", notes = "修改惩罚表")
	public boolean updateByIdRetribution(HttpServletRequest request, @RequestBody Retribution retribution) {
		return iRetributionService.updateById(retribution);
	}

	/**
	 * 根据id查询
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public Retribution selectById(HttpServletRequest request, @PathVariable Long id) {
		return iRetributionService.getById(id);
	}

	/**
	 * 列表分页查询
	 *
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<RetributionVo> listPage(CommonPageableDto pageable, RetributionVo retributionVo) {
		Person person = getPerson();
		if (person != null) {
			retributionVo.setPersonId(person.getId());
		}
		if (StringUtil.isNotEmpty(retributionVo.getTaskName())) {
			retributionVo.setTaskName("%" + retributionVo.getTaskName() + "%");
		}
		if (StringUtil.isNotEmpty(retributionVo.getTaskNo())) {
			retributionVo.setTaskNo("%" + retributionVo.getTaskNo() + "%");
		}
		return iRetributionService.pageInfo(pageable, retributionVo);
	}

	/**
	 * 查处违章总数查询
	 *
	 * @return
	 */
	@RequestMapping(value = "/total", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "查处违章总数查询", notes = "查处违章总数查询")
	public Object listTotal() {
		Response response = new Response();
		Map ret = new HashMap();
		Person person = getPerson();
		if (person != null) {
			Map map = new HashMap();
			map.put("person_id", person.getId());
			List<Retribution> list = (List<Retribution>) iRetributionService.listByMap(map);
			BigDecimal sumMoney = BigDecimal.ZERO;
			if (list != null && list.size() > 0) {
				sumMoney = list.stream().map(Retribution::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
			}
			ret.put("total", list.size());
			ret.put("sumMoney", sumMoney.toPlainString());
		} else {
			ret.put("sumMoney", Integer.MIN_VALUE);
			ret.put("total", Integer.MIN_VALUE);
		}
		response.setData(ret);
		return response;
	}

	/**
	 * 所有分包商违章统计排名 以人员违章表为主，该表有该分包商下的人员则该分包商出现
	 */
	@GetMapping("/list/company")
	@ApiOperation(httpMethod = "GET", value = "所有分包商违章统计排名  以人员违章表为主，该表有该分包商下的人员则该分包商出现", notes = "所有分包商违章统计排名  以人员违章表为主，该表有该分包商下的人员则该分包商出现")
	public IPage<RewardOrgCodeVo> listPageByOrgCode(StudioPageableDto pageable,
			@RequestParam(value = "companyName", required = false) String companyName) {
		return iRetributionService.listPageComcany(pageable, companyName, null);
	}

	/**
	 * 根据人员id查询该人员的违章列表
	 */
	@GetMapping("/list/user/detail")
	@ApiOperation(httpMethod = "GET", value = "根据人员id查询该人员的奖励详情列表", notes = "根据人员id查询该人员的奖励详情列表")
	public IPage<RewardListVo> rewardUserListDetail(StudioPageableDto pageable, RewardListVo rewardVo) {
		return iRetributionService.rewardUserListDetail(pageable, rewardVo);
	}

	/**
	 * 根据分包商companyId 查询该分包商下的所有 人员违章列表
	 *
	 * @return
	 */
	@RequestMapping(value = "/person/list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "某个用户惩罚 列表分页查询", notes = "某个用户惩罚 列表分页查询")
	public IPage<RetributionVo> listPageByPersonId(CommonPageableDto pageable, RetributionVo retributionVo) {
		if (StringUtils.isEmpty(retributionVo.getCompanyId())) {
			return new Page<>(pageable.getPageNumber(), pageable.getPageSize());
		}
		if (StringUtil.isNotEmpty(retributionVo.getProjectName())) {
			retributionVo.setProjectName("%" + retributionVo.getProjectName() + "%");
		}
		return iRetributionService.pageCompanyInfo(pageable, retributionVo);
	}

	/**
	 * 分包商违章排名列表
	 */
	@GetMapping("/list/company/bad")
	@ApiOperation(httpMethod = "GET", value = "所有分包商违章统计排名  以人员违章表为主，该表有该分包商下的人员则该分包商出现", notes = "所有分包商违章统计排名  以人员违章表为主，该表有该分包商下的人员则该分包商出现")
	public IPage<RewardOrgCodeVo> listBadPageByOrgCode(StudioPageableDto pageable,
			RewardOrgCodeVo rewardOrgCodeVo) {
		return iRetributionService.listBadPageCompany(pageable, rewardOrgCodeVo, null);
	}

}
