package com.yeejoin.amos.boot.module.tzs.flc.api.enums;

import lombok.Getter;

/**
 * 设备告知书状态枚举
 */
@Getter
public enum EquipmentInformStatusEnum {

    暂存("0", "暂存"),
    未接收("1", "未接收"),
    已接收("2", "已接收"),
    已驳回("9", "已驳回");

    private String code;

    private String name;

    EquipmentInformStatusEnum(String code, String name) {
        this.name = name;
        this.code = code;
    }

    public static EquipmentInformStatusEnum getByCode(String code) {
        for (EquipmentInformStatusEnum statusEnum : EquipmentInformStatusEnum.values()) {
            if (statusEnum.getCode().equals(code)) {
                return statusEnum;
            }
        }
        return null;
    }
}
