package com.yeejoin.amos.boot.module.ugp.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum QuestionComeFromEnum {
    /**
     * 问题来源
     */
    AUTO("1", "自动生成"),
    HAND_MOVE("2", "手动录入"),
    OVER_DUE("3", "超期转入");

    private final String code;
    private final String name;

    public String getCode() {
        return code;
    }
    public String getName() {
        return name;
    }

    public static String getTypeByCode(String code){
        for (QuestionComeFromEnum constants : values()) {
            if (constants.getCode().equals(code)) {
                return constants.getName();
            }
        }
        return null;
    }
}
