package com.yeejoin.amos.boot.module.ugp.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.aspectj.weaver.ast.Test;
import org.springframework.web.multipart.MultipartFile;

import java.util.Date;

/**
 * 焊机设备表
 *
 * @author system_generator
 * @date 2022-10-8
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="WelderEquipmentDto", description="焊机设备表")
public class WelderEquipmentDto extends BaseDto{

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "设备名称")
    private String name;

    @ApiModelProperty(value = "设备编号")
    private String code;

    @ApiModelProperty(value = "设备类型")
    private String type;

    @ApiModelProperty(value = "项目ID")
    private Long projectId;

    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @ApiModelProperty(value = "生产厂家")
    private String manufacturer;

    @ApiModelProperty(value = "出厂日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date manufactureDate;

    @ApiModelProperty(value = "使用年限")
    private String serviceLife;

    @ApiModelProperty(value = "校验日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date inspectionDate;

    @ApiModelProperty(value = "使用状态")
    private String useStatus;

    @ApiModelProperty(value = "检定状态")
    private String verifyStatus;

    @ApiModelProperty(value = "附件信息")
    private String info;

    @ApiModelProperty(value = "资源id")
    private String projectResourceId;

    @ApiModelProperty(value = "附件")
    private MultipartFile[] files;
}
