package com.yeejoin.amos.api.householdapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.util.Date;

/**
 * 户用光伏-厂商API haders
 *
 * @author system_generator
 * @date 2023-06-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("household_pv_api")
public class HouseholdPvApi extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 厂商id
     */
	@TableField("producer_id")
    private String producerId;

    /**
     * api名称
     */
	@TableField("api_name")
    private String apiName;

    /**
     * 请求方式 GET或者POST
     */
	@TableField("request_method")
    private String requestMethod;

    /**
     * api地址
     */
	@TableField("api_url")
    private String apiUrl;

    /**
     * api描述
     */
	@TableField("api_descption")
    private String apiDescption;

    /**
     * 参数信息
     */
	@TableField("param_info")
    private String paramInfo;
    /**
     * 依赖的apiId
     */
    @TableField("dependecy_api_id")
    private String dependecyApiId;
    /**
     * 缓存的属性
     */
    @TableField("cache_field")
    private String cacheField;
    /**
     * 依赖的api属性
     */
    @TableField("depend_api_param_key")
    private String dependApiParamKey;
    /**
     * result解析结果
     */
    @TableField("result_resolve_rule")
    private String resultResolveRule;
    /**
     * 是否分页
     */
    @TableField("is_page")
    private Integer isPage;

    /**
     * 时序库中存储的表名
     */
    @TableField("measurement")
    private String measurement;

    /**
     * 页数解析规则
     */
    @TableField("pagesize_resolve_rule")
    private String pagesizeResolveRule;

    /**
     * 页码对应的请求中的字段
     */
    @TableField("page_field")
    private String pageField;
}
