package com.yeejoin.amos.boot.module.ccs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 消防视频表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FireVideoDto", description = "消防视频表")
public class FireVideoDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "站点编码")
    private String stationCode;

    @ApiModelProperty(value = "站点名称")
    private String stationName;

    @ApiModelProperty(value = "唯一标识")
    private String mrid;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "安装位置")
    private String position;

    @ApiModelProperty(value = "图片")
    private String photoUrl;

    @ApiModelProperty(value = "所在建筑")
    private String buildingMrid;

    @ApiModelProperty(value = "所在建筑名称")
    private String buildingName;

    @ApiModelProperty(value = "视频播放地址")
    private String playUrl;

    @ApiModelProperty(value = "经度")
    private String lng;

    @ApiModelProperty(value = "纬度")
    private String lat;

    @ApiModelProperty(value = "关联的电力设备mrids")
    private String relationEquipmentMrids;

    @ApiModelProperty(value = "关联的消防设备mrids")
    private String relationFireEquipmentMrids;

}
