package com.yeejoin.amos.boot.module.ccs.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * @author DELL
 */

@Getter
@AllArgsConstructor
public enum StationOrderByTypeEnum {

    SAFETY_INDEX_DESC("1", "安全指数倒序", "order by safety_index desc"),
    ALARM_TIMES_DESC("2", "今日告警数倒序", "order by todayAlarmTimes desc");

    private String code;
    private String name;
    private String orderBy;

    public static Optional<StationOrderByTypeEnum> getEnum(String code) {
        return Arrays.stream(StationOrderByTypeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst();
    }
}
