package com.yeejoin.equipmanage.common.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.annotation.FillCommonUserField;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 报告流水表
 *
 * @author duanwei
 * @date 2021-05-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_analysis_report_log")
@FillCommonUserField(isAutoFill = false)
@ApiModel(value = "AnalysisReportLog对象", description = "报告流水表")
public class AnalysisReportLog extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "部门code")
    private String orgCode;

    @ApiModelProperty(value = "报告名称")
    private String name;

    @ApiModelProperty(value = "0日对比，1周分析，2月总结")
    private Integer reportType;

    @ApiModelProperty(value = "报告日期描述")
    private String reportDateDesc;

    @ApiModelProperty(value = "开始时间")
    private Date startDate;

    @ApiModelProperty(value = "结束时间")
    private Date endDate;


}
