package com.yeejoin.equipmanage.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zjw
 */
public enum ConfirmAlamEnum {

    HZGJ("FIREALARM", "火警"),
    GZ("BREAKDOWN", "故障"),
    WB("wrong", "误报"),
    PB("SHIELD", "屏蔽"),
    CS("test", "测试"),
    YJ("NOTICE", "预警"),
    GJ("warning", "告警");

    private String code;
    private String type;

    ConfirmAlamEnum(String code, String type) {
        this.code=code;
        this.type=type;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static Map<String, String> typeMap = new HashMap<>();

    static {
        ConfirmAlamEnum[] types = ConfirmAlamEnum.values();
        for (ConfirmAlamEnum type : types) {
            typeMap.put(String.valueOf(type.code), type.type);
        }
    }

    public static String getTypeByCode(String code) {
        for (ConfirmAlamEnum status: ConfirmAlamEnum.values()) {
            if (status.getCode().equalsIgnoreCase(code)) {
                return status.getType();
            }
        }
        return null;
    }

    public static String getEnumByName(String type) {
        for (ConfirmAlamEnum status: ConfirmAlamEnum.values()) {
            if (status.getType().equals(type)) {
                return status.getCode();
            }
        }
        return null;
    }


}
