package com.yeejoin.equipmanage.common.utils;

/**
 * 文档中图片命名存储处理
 * @author nihuanshan
 */
import org.apache.poi.xwpf.converter.core.IURIResolver;

public class MyURIResolver implements IURIResolver {

	private static final String SLASH = "/";

	private final String baseURL;

	public MyURIResolver(String baseURL) {
		if (!baseURL.endsWith(SLASH)) {
			baseURL += SLASH;
		}
		this.baseURL = baseURL;
	}

	public String resolve(String uri) {
		System.out.println("uri:" + uri);
		String s1 = uri.substring(0, uri.lastIndexOf("/") + 1);
		String s2 = uri.substring(1 + uri.lastIndexOf("/"));
		uri = s1 + FilePrefix.getFilePrefix() + s2;
		if (uri.startsWith(SLASH)) {
			return baseURL + uri.substring(1, uri.length());
		}
		return baseURL + uri;
	}
}
