package com.yeejoin.amos.boot.module.jcs.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.dto.FormValue;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertCalled;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 
 * 动态表单值
 * */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="AlertCalledFormDto", description=" 动态表单值")
public class AlertCalledFormDto extends BaseDto{
	
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "警情基本信息")
	    private AlertCalled alertCalled;

	    @ApiModelProperty(value = "动态表单值")
	    private List<FormValue> dynamicFormAlert;


	public AlertCalledFormDto(AlertCalled alertCalled, List<FormValue> formValue) {
		this.alertCalled = alertCalled;
		this.dynamicFormAlert = formValue;
	}
}
