//package com.yeejoin.equipmanage.config;
//
//import java.util.Date;
//import java.util.Map;
//
//import javax.servlet.http.HttpServletRequest;
//
//import org.apache.commons.lang3.StringUtils;
//import org.apache.ibatis.reflection.MetaObject;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Component;
//import org.springframework.util.ObjectUtils;
//
//import com.alibaba.fastjson.JSONObject;
//import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
//import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
//import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
//import com.yeejoin.equipmanage.common.annotation.FillCommonUserField;
//import com.yeejoin.equipmanage.common.config.GlobalCache;
//
///**
// * @description: 处理mybatis业务处理, 新增和更新的基础数据填充，配合BaseEntity和MyBatisPlusConfig使用
// * @author: duanwei
// * @create: 2020-05-28 13:57
// **/
//@Component
//public class MetaHandler implements MetaObjectHandler {
//
//	@Autowired
//	protected HttpServletRequest request;
//
//	protected String getToken() {
//		String authToken = request.getHeader("token");
//		if (authToken == null) {
//			authToken = request.getHeader("X-Access-Token");
//		}
//		return authToken;
//	}
//
//	/**
//	 * 新增数据拦截
//	 *
//	 * @param metaObject
//	 */
//	@Override
//	public void insertFill(MetaObject metaObject) {
//		Date currentDate = new Date();
//		Class clazz = metaObject.getOriginalObject().getClass();
//		FillCommonUserField annotation = (FillCommonUserField) clazz.getAnnotation(FillCommonUserField.class);
//		if(annotation == null || annotation.isAutoFill()){
//			autoFillUser(metaObject);
//		}
//		//如果有上传创建时间，不需要修改
//		if(metaObject.getValue("createDate")==null){
//			this.setFieldValByName("createDate", currentDate, metaObject);
//		}
//	}
//
//	private void autoFillUser(MetaObject metaObject) {
//		Object obj = GlobalCache.paramMap.get(getToken());
//		if(ObjectUtils.isEmpty(obj)){
//			return;
//		}
//		@SuppressWarnings("unchecked")
//		Map<String, String> map = JSONObject.parseObject(obj.toString(), Map.class);
//		AgencyUserModel user = JSONObject.parseObject(map.get("user"), AgencyUserModel.class);
//		ReginParams reginParams = JSONObject.parseObject(map.get("org"), ReginParams.class);
//		Object entity = metaObject.getOriginalObject();
//		if (isExistField("userId", entity)) {
//			this.setFieldValByName("userId", Long.valueOf(user.getUserId()), metaObject);
//		}
//		if (isExistField("creatorId", entity)) {
//			this.setFieldValByName("creatorId", Long.valueOf(user.getUserId()), metaObject);
//		}
//		if (isExistField("userName", entity)) {
//			this.setFieldValByName("userName", user.getRealName(), metaObject);
//		}
//		if (isExistField("companyName", entity)) {
//			this.setFieldValByName("companyName", reginParams.getCompany().getCompanyName(), metaObject);
//		}
//		if (isExistField("orgCode", entity)) {
//			this.setFieldValByName("orgCode", reginParams.getCompany().getOrgCode(), metaObject);
//		}
//		if (isExistField("departmentName", entity)) {
//			this.setFieldValByName("departmentName", ObjectUtils.isEmpty(reginParams.getDepartment())?"":reginParams.getDepartment().getDepartmentName(), metaObject);
//		}
//		if (isExistField("departmentOrgcode", entity)) {
//			this.setFieldValByName("departmentOrgcode", ObjectUtils.isEmpty(reginParams.getDepartment())?"":reginParams.getDepartment().getOrgCode(), metaObject);
//		}
//	}
//
//	private Boolean isExistField(String field, Object obj) {
//		if (obj == null || StringUtils.isEmpty(field)) {
//			return null;
//		}
//		Object o = JSONObject.toJSON(obj);
//		JSONObject jsonObj = new JSONObject();
//		if (o instanceof JSONObject) {
//			jsonObj = (JSONObject) o;
//			if (jsonObj.get(field) != null) {
//				return Boolean.FALSE;
//			}
//		}
//		return jsonObj.containsKey(field);
//	}
//
//	/**
//	 * 更新拦截
//	 *
//	 * @param metaObject
//	 */
//	@Override
//	public void updateFill(MetaObject metaObject) {
//		Date currentDate = new Date();
//		this.setFieldValByName("updateDate", currentDate, metaObject);
//	}
//
//}