package com.yeejoin.equipmanage.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.datasync.enums.EquipmentStandardEnum;
import com.yeejoin.equipmanage.common.entity.Equipment;
import com.yeejoin.equipmanage.common.entity.EquipmentStandard;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentStandardVO;
import com.yeejoin.equipmanage.common.exception.BaseException;
import com.yeejoin.equipmanage.fegin.MaintenanceFeign;
import com.yeejoin.equipmanage.service.IEquipmentService;
import com.yeejoin.equipmanage.service.IEquipmentStandardService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;


/**
 * @author chenhao
 * @date 2020-07-07
 */
@RestController
@Api(tags = "装备标准Api")
@RequestMapping(value = "/equipment-standard", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class EquipmentStandardController extends AbstractBaseController {

    @Autowired
    IEquipmentStandardService iEquipmentStandardService;

    @Autowired
    private MaintenanceFeign maintenanceFeign;

    @Autowired
    IEquipmentService equipmentService;

    /**
     * 新增
     *
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public boolean saveEquipmentStandard(HttpServletRequest request, @RequestBody EquipmentStandard equipmentStandard) {
        //当前维保安全员操作添加的维保规范的类型，默认是0。type的类型是为了区分当前的维保规范的内容来源
        equipmentStandard.setType(EquipmentStandardEnum.EQUIPMENT_STANDARD_PEGA_DEFAULT_TYPE.getText());
        equipmentStandard.setOrgCode(getOrgCode());
        equipmentStandard.setCreateId(RequestContext.getExeUserId());
        this.checkEquipAndSengPatrol(equipmentStandard);
        QueryWrapper<EquipmentStandard> qw = new QueryWrapper<>();
        qw.lambda().eq(EquipmentStandard::getEquipmentId, equipmentStandard.getEquipmentId())
                .eq(EquipmentStandard::getType, equipmentStandard.getType())
                .eq(EquipmentStandard::getOrgCode, equipmentStandard.getOrgCode());
        int count = iEquipmentStandardService.count(qw);
        if (count > 0) {
            throw new BaseException("该单位下该装备的规范已存在");
        }
        return iEquipmentStandardService.save(equipmentStandard);
    }

    /**
     * 根据id删除
     *
     * @param ids
     * @return
     */
    @RequestMapping(value = "", method = RequestMethod.DELETE)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(@ApiParam(value = "支持批量删除，ids-逗号分隔") @RequestParam String ids) {
        return iEquipmentStandardService.removeByIds(Arrays.asList(ids.split(",")));
    }

    /**
     * 获取本公司还没有添加维保规范的装备名称
     *
     * @param request
     * @param
     * @return
     */
    @RequestMapping(value = "/getEquipmentName", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取本公司还没有添加维保规范的装备名称", notes = "获取本公司还没有添加维保规范的装备名称")
    public List<Map<String, String>> getNoAddEquipmentStandardNameList() {
        String orgCode = getOrgCode();
        return iEquipmentStandardService.getNoAddEquipmentStandardNameList(orgCode);
    }

    /**
     * 修改
     *
     * @return
     */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
    public boolean updateByIdEquipmentStandard(@RequestBody EquipmentStandard equipmentStandard) {
        this.checkEquipAndSengPatrol(equipmentStandard);
        equipmentStandard.setCreateId(RequestContext.getExeUserId());
        return iEquipmentStandardService.updateById(equipmentStandard);
    }

    private void checkEquipAndSengPatrol(@RequestBody EquipmentStandard equipmentStandard) {
        Equipment equipment = equipmentService.getById(equipmentStandard.getEquipmentId());
        if (equipment == null) {
            throw new BaseException("装备定义不存在");
        }
        JSONObject equipRuleParams = new JSONObject();
        equipRuleParams.put("name", equipment.getName());
        equipRuleParams.put("inspectionSpecId", equipmentStandard.getStandardKey());
        maintenanceFeign.getEquipDetail(equipRuleParams.toJSONString());
    }


    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/find/{id}", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public EquipmentStandardVO selectById(@PathVariable Long id) {
        return iEquipmentStandardService.findById(id);
    }

    /**
     * 列表分页查询
     *
     * @return
     */
    @RequestMapping(value = "/page/list", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<EquipmentStandardVO> listPage(int pageNum, int pageSize, String standardKey, String equipmentName) {
        Page page = new Page();
        page.setCurrent(pageNum);
        if (-1 == pageSize) {
            page.setSize(Integer.MAX_VALUE);
        } else {
            page.setSize(pageSize);
        }
        String orgCode = getOrgCode();
        return iEquipmentStandardService.findEquipmentStandardList(page, orgCode, standardKey, equipmentName);
    }

}


