package com.yeejoin.equipmanage.event;

import com.yeejoin.equipmanage.common.entity.EquipmentCategory;
import org.springframework.context.ApplicationEvent;

import java.util.Set;


public class EquipmentTreeListEvent extends ApplicationEvent {
    private EquipmentCategory equipmentCategory;
    private Set<String> idSet;
    private Set<String> typeSet;
    public EquipmentTreeListEvent(Object source, EquipmentCategory equipmentCategory) {
        super(source);
        this.equipmentCategory = equipmentCategory;
    }

    public EquipmentTreeListEvent(Object source, Set<String> idSet, Set<String> typeSet) {
        super(source);
        this.idSet = idSet;
        this.typeSet = typeSet;
    }

    public EquipmentCategory equipmentCategory(){
        return this.equipmentCategory;
    }
    public Set<String> idSet(){
        return this.idSet;
    }
    public Set<String> typeSet(){
        return this.typeSet;
    }
}
