package com.yeejoin.equipmanage.operation;
import com.yeejoin.equipmanage.common.entity.dto.BuildSearchDTO;
import com.yeejoin.equipmanage.context.SpringContextHolder;
import com.yeejoin.equipmanage.remote.RiskModelFeign;
import com.yeejoin.equipmanage.remote.RiskSource;
import com.yeejoin.equipmanage.service.IFormInstanceService;
import com.yeejoin.equipmanage.service.impl.FormInstanceServiceImpl;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author: songLei
 * @Description: 同步风险区域操作类型
 * @Date: 2020/12/29 17:43
 * @Version: 1.0
 */
@Slf4j
@Getter
@AllArgsConstructor
public enum SyncRiskOperator {
    ADD("ADD") {
        @Override
        public void apply(Map<String, Object> map) {
            log.info("添加同步风险区域操作");
            if (map.get("isRisk").equals("true")) {
                RiskModelFeign riskModelFeign = SpringContextHolder.getBean(RiskModelFeign.class);
                RiskSource riskSource = new RiskSource();
                List<RiskSource> riskSources = new ArrayList<>();
                if (map.get("isSetChildToRiskArea").equals("false")) {
                    riskSource.setCode(String.valueOf(map.get("code")));
                    riskSource.setId(Long.parseLong(String.valueOf(map.get("instanceId"))));
                    riskSource.setName(String.valueOf(map.get("name")));
                    riskSource.setParentId(Long.parseLong(String.valueOf(map.get("riskPointId"))));
                    riskModelFeign.addSyncRisk(riskSource);
                } else {
                    IFormInstanceService formInstanceService = SpringContextHolder.getBean(FormInstanceServiceImpl.class);
                    BuildSearchDTO buildSearchDTO = new BuildSearchDTO();
                    buildSearchDTO.setInstanceId(String.valueOf(map.get("riskPointId")));
                    List<Map<String, Object>> mapList = formInstanceService.queryPage(buildSearchDTO);
                    mapList.stream().forEach(item -> {
                        Map<String, Object> newMap = new HashMap<>(16);
                        newMap.put("riskPointId", Long.parseLong(String.valueOf(map.get("riskPointId"))));
                        newMap.put("name", String.valueOf(item.get("buildName")));
                        newMap.put("isRisk", Boolean.TRUE);
                        newMap.put("parentId", item.get("parentId"));
                        RiskSource riskSource1 = new RiskSource();
                        Map<String, Object> createMap = formInstanceService.createByMap(String.valueOf(item.get("groupCode")),
                                String.valueOf(map.get("companyCode")), newMap);
                        riskSource1.setParentId(Long.parseLong(String.valueOf(map.get("riskPointId"))));
                        riskSource1.setName(String.valueOf(item.get("buildName")));
                        riskSource1.setId(Long.parseLong(String.valueOf(createMap.get("instanceId"))));
                        riskSource1.setCode(String.valueOf(createMap.get("code")));
                        riskSources.add(riskSource1);
                    });
                    riskSource.setCode(String.valueOf(map.get("code")));
                    riskSource.setId(Long.parseLong(String.valueOf(map.get("instanceId"))));
                    riskSource.setName(String.valueOf(map.get("name")));
                    riskSource.setParentId(Long.parseLong(String.valueOf(map.get("riskPointId"))));
                    riskSource.setChildren(riskSources);
                    riskModelFeign.addSyncRisk(riskSource);
                }
            }
        }
    },
    UPDATE("UPDATE") {
        @Override
        public void apply(Map<String, Object> map) {
            log.info("编辑同步风险区域操作操作");
            IFormInstanceService formInstanceService = SpringContextHolder.getBean(FormInstanceServiceImpl.class);
            RiskModelFeign riskModelFeign = SpringContextHolder.getBean(RiskModelFeign.class);
            RiskSource riskSource = new RiskSource();
            List<RiskSource> riskSources = new ArrayList<>();
            if (map.get("isRisk").equals("true")) {
                BuildSearchDTO buildSearchDTO = new BuildSearchDTO();
                buildSearchDTO.setInstanceId(String.valueOf(map.get("instanceId")));
                List<Map<String, Object>> mapList = formInstanceService.queryPage(buildSearchDTO);
                if (map.get("isSetChildToRiskArea").equals("false")) {
                    riskSource.setCode(String.valueOf(map.get("code")));
                    riskSource.setId(Long.parseLong(String.valueOf(map.get("instanceId"))));
                    riskSource.setName(String.valueOf(map.get("name")));
                    riskSource.setParentId(Long.parseLong(String.valueOf(map.get("riskPointId"))));
                    riskModelFeign.addSyncRisk(riskSource);
                } else {
                    // 过滤掉已经被设置为风险点的子集节点
                    mapList.stream().filter(item -> item.get("isRisk").equals("false"))
                            .collect(Collectors.toList()).stream().forEach(x->{
                        RiskSource riskSource1 = new RiskSource();
                        Map<String,Object> newMap = formInstanceService.queryForMap(Long.parseLong(String.valueOf(x.get("instanceId"))));
                        newMap.put("isRisk", Boolean.TRUE);
                        newMap.put("riskPointId", Long.parseLong(String.valueOf(map.get("riskPointId"))));
                        formInstanceService.updateInstance(Long.parseLong(String.valueOf(x.get("instanceId"))),
                                String.valueOf(map.get("companyCode")), newMap);
                        riskSource1.setParentId(Long.parseLong(String.valueOf(map.get("riskPointId"))));
                        riskSource1.setName(String.valueOf(x.get("buildName")));
                        riskSource1.setId(Long.parseLong(String.valueOf(x.get("instanceId"))));
                        riskSource1.setCode(String.valueOf(x.get("buildCode")));
                        riskSources.add(riskSource1);
                    });
                    riskSource.setCode(String.valueOf(map.get("code")));
                    riskSource.setId(Long.parseLong(String.valueOf(map.get("instanceId"))));
                    riskSource.setName(String.valueOf(map.get("name")));
                    riskSource.setParentId(Long.parseLong(String.valueOf(map.get("riskPointId"))));
                    riskSource.setChildren(riskSources);
                    riskModelFeign.addSyncRisk(riskSource);
                }
            } else {
                riskModelFeign.editSyncRisk(Long.parseLong(String.valueOf(map.get("instanceId"))));
            }
        }
    },
    DELETE("DELETE") {
        @Override
        public void apply(Map<String, Object> map) {
            log.info("删除操作");
            RiskModelFeign riskModelFeign = SpringContextHolder.getBean(RiskModelFeign.class);
            riskModelFeign.editSyncRisk(Long.parseLong(String.valueOf(map.get("instanceId"))));
        }
    };

    public abstract void apply(Map<String, Object> map);

    private String type;
}
