package com.yeejoin.equipmanage.service;

import com.yeejoin.equipmanage.common.vo.EquipmentAccountFilterVo;
import com.yeejoin.equipmanage.common.vo.EquipmentHistoryVo;

import java.util.List;
import java.util.Map;

/**
 * 服务类
 *
 * @author zjw
 * @date 2020-09-17
 */
public interface EquipmentAccountService {
    /**
     * 获取台账信息列表
     * @param eType
     * @param eName
     * @param spage
     * @param pageSize
     * @return
     */
    Map<String, Object> getAccounList(String eType,String eName,int spage,int pageSize);

    /**
     * 根据分类id 获取装备和车辆
     * @param id
     * @return
     */
    List<EquipmentAccountFilterVo> getNameList(String id);

    /**
     * 获取车辆列表
     * @param carNum
     * @param spage
     * @param pageSize
     * @param equipmentName
     * @param accType
     * @return
     */
    Map<String, Object> getMoreCarList(String carNum,int spage,int pageSize,String equipmentName ,String accType);

    /**
     * 获取装备类别
     * @param code
     * @param spage
     * @param pageSize
     * @param equipmentName
     * @param accType
     * @return
     */
    Map<String, Object> getMoreAccList(String code,int spage,int pageSize,String equipmentName ,String accType);

    /**
     * 查询流水
     * @param id
     * @return
     */
    List<EquipmentHistoryVo> selectHistoryById(Long id);

    /**
     * 获取生产日期
     * @param id
     * @return
     */
    Map<String, Object>  getAccData(Long id);

}
