package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.biz.common.dto.OrgMenuDto;
import com.yeejoin.equipmanage.common.entity.Video;
import com.yeejoin.equipmanage.common.entity.dto.VideoDTO;
import com.yeejoin.equipmanage.common.entity.dto.VideoSaveDto;
import com.yeejoin.equipmanage.common.entity.vo.*;

import java.util.List;
import java.util.Map;

/**
 * @author ZeHua Li
 * @date 2020/11/23 15:28
 * @since v2.0
 */
public interface IVideoService extends IService<Video> {
    Video saveVideo(VideoSaveDto videoSave);

    Boolean delVideo(List<Long> ids);

    Video updateVideo(VideoSaveDto videoSave);

    Page<PageVideoVO> pageVideo(VideoDTO videoDTO);

    VideoSaveDto detail(Long id);

    Page<BuildingVideoVO> pageBuildingVideo(Page page, BuildingVideoListVO dto);

    /**
     * 视屏监控绑定的消防设备查询
     * @param videoId
     * @return
     */
    List<BuildingListVO> getFireEquipByVideoId(Long videoId);

    /**
     * 视屏监控绑定的消防设备查询
     * @param videoId
     * @return
     */
    List<BuildingListVO> getPowerEquipByVideoId(Long videoId);

    /**
     * 可乐视频列表展示
     * @param page
     * @param dto
     * @return
     */
    Page<BuildingVideoVO> pageColaBuildingVideo(Page page, BuildingVideoListVO dto);

    List<String> getSecurityCodeList();

    /**
     * 监控信息导入
     * @param videoDownloadVOS
     * @return
     */
    List<Video> videoUpload(List<VideoDownloadVO> videoDownloadVOS);


    List<VideoListVo> pageVideoList(Integer pageNum, Integer pageSize, Double longitude, Double latitude, Double distance);
    int pageVideoCount( Double longitude,
                        Double latitude,
                        Double distance) ;

    List<VideoListVo>listByType(String type);
    
    List<Video> listByCode(String code);
    
    /**
     * 获取视频播放地址
     * @param videoId
     * @param presetIndex
     * @param defaultUrl
     * @return
     */
    String getVideoUrl(String videoId, String presetIndex, String defaultUrl, String code);

    List<OrgMenuDto> companyTreeByUserAndType(String type);

    /**
     * 获取机构下的监控数量
     * key：机构编码  value：数量
     * @return
     */
    Map<String, Long> getVideoCountMap();
}
