package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/8/25
 */
@Getter
@AllArgsConstructor
public enum ContractStatusEnum {
    草稿("DRAFT", "DRAFT"),

    已撤回("RECALLED", "RECALLED"),

    签署中("SIGNING", "SIGNING"),

    已退回("REJECTED", "REJECTED"),

    已完成("COMPLETE", "COMPLETE"),

    已过期("EXPIRED", "EXPIRED"),

    拟定中("FILLING", "FILLING"),

    签署失败("FAILED", "FAILED"),

    作废中("INVALIDING", "INVALIDING"),

    已作废("INVALIDED", "INVALIDED"),

    强制结束("END", "END");


    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    public static ContractStatusEnum getNodeByCode(String code) {
        ContractStatusEnum dealerReviewEnum = null;
        for(ContractStatusEnum type: ContractStatusEnum.values()) {
            if (type.getCode().equals(code)) {
                dealerReviewEnum = type;
                break;
            }
        }
        return dealerReviewEnum;
    }











}
