package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.hygf.api.dto.CommonFile;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 经销商人员信息
 *
 * @author system_generator
 * @date 2023-07-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_unit_info")
public class UnitInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 企业名称
     */
	@TableField("name")
    private String name;

    /**
     * 注册地址
     */
	@TableField("register_address")
    private String registerAddress;

    /**
     * 工作地址
     */
	@TableField("work_address")
    private String workAddress;

    /**
     * 负责人名称
     */
	@TableField("head_name")
    private String headName;

    /**
     * 负责人电话
     */
	@TableField("head_phone")
    private String headPhone;

    /**
     * 负责人身份证号码
     */
	@TableField("head_id_number")
    private String headIdNumber;

    /**
     * 负责人身份证照片正面
     */
	@TableField("head_card_photo_front")
    private String headCardPhotoFront;

    /**
     * 负责人身份证照片反面
     */
	@TableField("head_card_photo_back")
    private String headCardPhotoBack;

    /**
     * 管理员账户名
     */
	@TableField("admin_login_name")
    private String adminLoginName;

    /**
     * 管理员电话
     */
	@TableField("admin_phone")
    private String adminPhone;

    /**
     * 管理员密码
     */
	@TableField("admin_login_pwd")
    private String adminLoginPwd;

    /**
     * 管理员平台用户id
     */
	@TableField("admin_user_id")
    private String adminUserId;

    /**
     * 平台公司id
     */
	@TableField("amos_company_seq")
    private Long amosCompanySeq;

    /**
     * 上级单位id
     */
	@TableField("parent_unit_id")
    private Long parentUnitId;

    /**
     * 角色id
     */
	@TableField("role_id")
    private String roleId;

    /**
     * 管理员账户名
     */
    @TableField("admin_user_name")
    private String adminUserName;

    /**
     * 注册地址省-市-区
     */
    @TableField("register_pcd")
    private String registerPcd;

    /**
     * 工作地址省-市-区
     */
    @TableField("work_Pcd")
    private String workPcd;

    /**
     * 注册地址省-市-区code
     */
    @TableField("register_pcd_code")
    private String registerPcdCode;

    /**
     * 工作地址省-市-区code
     */
    @TableField("work_pcd_code")
    private String workPcdCode;

    /**
     * 单位类型
     */
    @TableField("unit_type")
    private String unitType;

    /**
     * 单位类型code
     */
    @TableField("unit_type_code")
    private String unitTypeCode;

    /**
     * 管辖机构
     */
    @TableField("management_unit")
    private String managementUnit;

    /**
     * 管辖单位id
     */
    @TableField("management_unit_id")
    private String managementUnitId;
    /**
     *是否加入黑名单
     * */
    @TableField("blacklist")
    private int blacklist;
    /**
     *审核状态
     * */
    @TableField("audit_status")
    private int auditStatus;



    //所属区域公司id
    @TableField(value = "regional_companies_seq",typeHandler = FastjsonTypeHandler.class)
    private List<Long> regionalCompaniesSeq;
    //所属区域公司名称
    @TableField("regional_companies_name")
    private String regionalCompaniesName;
    //所属区域公司code
    @TableField("regional_companies_code")
    private String regionalCompaniesCode;



    @TableField(exist=false)
    private List<CommonFile> headCardPhotoFrontList;
    @TableField(exist=false)
    private List<CommonFile> headCardPhotoBackList;

}
