package com.yeejoin.amos.boot.module.hygf.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.ExtendedInformationServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.ExtendedInformationDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 扩展信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@RestController
@Api(tags = "扩展信息Api")
@RequestMapping(value = "/extended-information")
public class ExtendedInformationController extends BaseController {

    @Autowired
    ExtendedInformationServiceImpl extendedInformationServiceImpl;

    /**
     * 新增扩展信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增扩展信息", notes = "新增扩展信息")
	public ResponseModel<ExtendedInformationDto> save(@RequestBody ExtendedInformationDto model) {
	    model = extendedInformationServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新扩展信息", notes = "根据sequenceNbr更新扩展信息")
	public ResponseModel<ExtendedInformationDto> updateBySequenceNbrExtendedInformation(@RequestBody ExtendedInformationDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(extendedInformationServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除扩展信息", notes = "根据sequenceNbr删除扩展信息")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(extendedInformationServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个扩展信息",  notes = "根据sequenceNbr查询单个扩展信息")
	public ResponseModel<ExtendedInformationDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(extendedInformationServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "扩展信息分页查询",  notes = "扩展信息分页查询")
	public ResponseModel<Page<ExtendedInformationDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<ExtendedInformationDto> page = new Page<ExtendedInformationDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(extendedInformationServiceImpl.queryForExtendedInformationPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "扩展信息列表全部数据查询",   notes = "扩展信息列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<ExtendedInformationDto>> selectForList() {
	    return ResponseHelper.buildResponse(extendedInformationServiceImpl.queryForExtendedInformationList());
	}
}
