package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.CommonServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * @author system_generator
 * @date 2023-08-11
 */
@RestController
@Api(tags = "智能分析")
@RequestMapping(value = "/analyse")
public class AnalyseController extends BaseController {

    @Autowired
    CommonServiceImpl commonServiceImpl;

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "工况测点区间划分-风机", notes = "工况测点区间划分-风机")
    @GetMapping(value = "/getFanConditionVariablesByTime")
    public ResponseModel<String> getFanConditionVariablesByTime(@RequestParam String startTime, @RequestParam String endTime) {
        return ResponseHelper.buildResponse(commonServiceImpl.getFanConditionVariablesByTimeThread(startTime, endTime));
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "工况测点区间划分-光伏", notes = "工况测点区间划分-光伏")
    @GetMapping(value = "/getPvConditionVariablesByTime")
    public ResponseModel<String> getPvConditionVariablesByTime(@RequestParam String startTime, @RequestParam String endTime) {
        return ResponseHelper.buildResponse(commonServiceImpl.getPvConditionVariablesByTimeThread(startTime, endTime));
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "相关性分析-风机", notes = "相关性分析-风机")
    @GetMapping(value = "/getFanConditionVariablesByTimeAnalyse")
    public ResponseModel<String> getFanConditionVariablesByTimeAnalyse(@RequestParam String startTime, @RequestParam String endTime) {
        return ResponseHelper.buildResponse(commonServiceImpl.getFanConditionVariablesByTimeAnalyseThread(startTime, endTime));
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "相关性分析-风机", notes = "相关性分析-风机")
    @GetMapping(value = "/getPvConditionVariablesByTimeAnalyse")
    public ResponseModel<String> getPvConditionVariablesByTimeAnalyse(@RequestParam String startTime, @RequestParam String endTime) {
        return ResponseHelper.buildResponse(commonServiceImpl.getPvConditionVariablesByTimeAnalyseThread(startTime, endTime));
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "中心值计算-风机", notes = "中心值计算-风机")
    @GetMapping(value = "/getFanConditionVariablesByTimeAnalyse1")
    public ResponseModel<String> getFanConditionVariablesByTimeAnalyse1(@RequestParam String startTime, @RequestParam String endTime) {
        return ResponseHelper.buildResponse(commonServiceImpl.getFanConditionVariablesByTimeAnalyse1Thread(startTime, endTime));
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "中心值计算-光伏", notes = "中心值计算-光伏")
    @GetMapping(value = "/getPvConditionVariablesByTimeAnalyse1")
    public ResponseModel<String> getPvConditionVariablesByTimeAnalyse1(@RequestParam String startTime, @RequestParam String endTime) {
        return ResponseHelper.buildResponse(commonServiceImpl.getPvConditionVariablesByTimeAnalyse1Thread(startTime, endTime));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "获取influxdb数据", notes = "获取influxdb数据")
    @GetMapping(value = "/getInfluxdbDataByConditon")
    public ResponseModel<Map<String, Object>> getInfluxdbDataByConditon(@RequestParam String stationType, @RequestParam String pointId, @RequestParam String startTime, @RequestParam String endTime) {
       return ResponseHelper.buildResponse(commonServiceImpl.getInfluxdbDataByConditon(stationType,pointId,startTime, endTime)) ;
    }
}
