package com.yeejoin.amos.boot.module.jxiop.api.feign;

import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.LoginInfoModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(name = "AMOS-API-PRIVILEGE", path = "privilege", configuration = {FeignConfiguration.class})
public interface AgencyuserFeign {

    @RequestMapping(value = "/v1/agencyuser/login-info/{loginId}" , method = RequestMethod.PUT)
    public FeignClientResult<LoginInfoModel> updateLoginInfo(@RequestBody AgencyUserModel model,
                                                             @PathVariable("loginId") String loginId);
}
