package com.yeejoin.amos.boot.module.jxiop.api.feign;

import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

@FeignClient(name = "${amos.idx.name:AMOS-IDX}", path = "idx", configuration = {FeignConfiguration.class})
public interface IdxFeign {

    /**
     * 根据风险来源查询人员红黄绿吗信息
     */
    @GetMapping("/jxIopAnalysis/healthIndexData")
    FeignClientResult<Map<String, Object>> healthIndexData(@RequestParam(required = false, value = "parentCode") String parentCode,
                                                           @RequestParam(required = false, value = "stationType") String stationType);

}
