package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.StationCoordinateServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.dto.StationCoordinateDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 场站坐标信息表
 *
 * @author system_generator
 * @date 2023-04-20
 */
@RestController
@Api(tags = "场站坐标信息表Api")
@RequestMapping(value = "/station-coordinate")
public class StationCoordinateController extends BaseController {

    @Autowired
    StationCoordinateServiceImpl stationCoordinateServiceImpl;

    /**
     * 新增场站坐标信息表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增场站坐标信息表", notes = "新增场站坐标信息表")
	public ResponseModel<StationCoordinateDto> save(@RequestBody StationCoordinateDto model) {
	    model = stationCoordinateServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新场站坐标信息表", notes = "根据sequenceNbr更新场站坐标信息表")
	public ResponseModel<StationCoordinateDto> updateBySequenceNbrStationCoordinate(@RequestBody StationCoordinateDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(stationCoordinateServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除场站坐标信息表", notes = "根据sequenceNbr删除场站坐标信息表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(stationCoordinateServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个场站坐标信息表",  notes = "根据sequenceNbr查询单个场站坐标信息表")
	public ResponseModel<StationCoordinateDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(stationCoordinateServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "场站坐标信息表分页查询",  notes = "场站坐标信息表分页查询")
	public ResponseModel<Page<StationCoordinateDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<StationCoordinateDto> page = new Page<StationCoordinateDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(stationCoordinateServiceImpl.queryForStationCoordinatePage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "场站坐标信息表列表全部数据查询",   notes = "场站坐标信息表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<StationCoordinateDto>> selectForList() {
	    return ResponseHelper.buildResponse(stationCoordinateServiceImpl.queryForStationCoordinateList());
	}
}
