package com.yeejoin.precontrol.common.dto;

import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yeejoin.precontrol.common.entity.ProjectAccount;
import com.yeejoin.precontrol.common.entity.ProjectCamera;
import com.yeejoin.precontrol.common.entity.ProjectCompany;
import com.yeejoin.precontrol.common.entity.ProjectCoordinate;
import com.yeejoin.precontrol.common.entity.ProjectDevice;

import cn.afterturn.easypoi.excel.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 项目信息Dto
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
public class ProjectDto extends BaseDto {
	private static final long serialVersionUID = 1L;
	@TableId(type = IdType.AUTO)
	private Long id;
	@ApiModelProperty(value = "项目名称")
	private String name;
	@ApiModelProperty(value = "手机号码")
	private Long phone;
	@ApiModelProperty(value = "项目经理")
	private String manager;
	@ApiModelProperty(value = "邮箱")
	private String email;
	@ApiModelProperty(value = "建设单位")
	private String company;
	@ApiModelProperty(value = "地区")
	private String region;
	@ApiModelProperty(value = "经度")
	private Double longitude;
	@ApiModelProperty(value = "纬度")
	private Double latitude;
	@ApiModelProperty(value = "打卡半径")
	private Double clockScope;
	@ApiModelProperty(value = "项目地址")
	private String address;
	@ApiModelProperty(value = "简介")
	private String introduction;
	@ApiModelProperty(value = "状态 0在建 1完工")
	private String status;
	@ApiModelProperty(value = "项目开始时间")
	private Date startTime;
	@ApiModelProperty(value = "项目编号")
	private String projectNum;
	@ApiModelProperty(value = "创建时间")
	private Date createDate;
	@ApiModelProperty(value = "企业id")
	private Long companyId;
	@ApiModelProperty(value = "项目ids")
	private List<Long> projectIds;
	@ApiModelProperty(value = "0违章")
	private Boolean isNoBad;
	@ApiModelProperty(value = "项目id")
	private Long projectId;
	@ApiModelProperty(value = "地图点类型")
	private String pointType;
	@ApiModelProperty(value = "地图数据")
	private String lineJson;
	@ApiModelProperty(value = "未交底次数")
	private Long jobNum;
	@ApiModelProperty(value = "机构ID")
	private String orgCode;
	@ApiModelProperty(value = "项目坐标信息")
	private List<ProjectCoordinate> projectCoordinateList;
	@ApiModelProperty(value = "项目分包商")
	private List<ProjectCompany> projectCompanyList;
	@ApiModelProperty(value = "项目设备")
	private List<ProjectDevice> projectDeviceList;
	private List<ProjectCamera> cameraList;
	private String projectRegion;
    @ApiModelProperty(value = "项目类型")
    private Integer type;
    @ApiModelProperty(value = "专户信息")
    private ProjectAccount projectAccount;
    @ApiModelProperty(value = "是否有专户")
    private boolean hasAccount;
}
