package com.yeejoin.precontrol.common.dto;

import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 短信流水表
 *
 * @author duanwei
 * @date 2021-01-27
 */
@Data
@ApiModel(value = "SmsLogDto", description = "短信流水表")
public class SmsLogDto extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "接收者")
    private String receiver;

    @ApiModelProperty(value = "验证码")
    private String authCode;

    @ApiModelProperty(value = "短信内容")
    private String body;

    @ApiModelProperty(value = "模板id")
    private String templateId;

    @ApiModelProperty(value = "1-未使用；2-已使用（暂时不用,放到redis）")
    private Integer status;

    @ApiModelProperty(value = "到期时间（暂时不用,放到redis）")
    private Date expireDate;

}
