package com.yeejoin.precontrol.common.enums;

/**
 * @Description: 人员关系表枚举
 * @Author: duanwei
 * @Date: 2020/10/29
 */
public enum AscriptionStatusEum {
	/**
	 * 在岗
	 */
	在岗("在岗", 0),
	/**
	 * 不在场
	 */
	离岗("离岗", 1);

	private String label;
	private int value;

	AscriptionStatusEum(String label, int value) {
		this.label = label;
		this.value = value;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public int getValue() {
		return value;
	}

	public void setValue(int value) {
		this.value = value;
	}

	public static String getLabelByValue(int value) {
		String label = null;
		for (AscriptionStatusEum type : AscriptionStatusEum.values()) {
			if (type.getValue() == value) {
				label = type.getLabel();
				break;
			}
		}
		return label;
	}
}
