package com.yeejoin.precontrol.common.publish;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.precontrol.common.listener.event.StatusEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

/**
 * @description:
 * @author: duanwei
 * @date: 2020-08-05 15:22
 **/
@Component
public class StatusEventPublish extends AbstractEventPublish {

    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    public void publish(String message) {
        StatusEvent statusEvent = new StatusEvent(this, message);
        applicationEventPublisher.publishEvent(statusEvent);
    }

    public void publish(JSONObject message) {
        StatusEvent statusEvent = new StatusEvent(this, message);
        applicationEventPublisher.publishEvent(statusEvent);
    }

}
