package com.yeejoin.precontrol.common.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.StudioPageableDto;
import com.yeejoin.precontrol.common.entity.Retribution;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.precontrol.common.vo.RetributionVo;
import com.yeejoin.precontrol.common.vo.RewardListVo;
import com.yeejoin.precontrol.common.vo.RewardOrgCodeVo;

/**
 * 惩罚表 服务类
 *
 * @author duanwei
 * @date 2021-04-06
 */
public interface IRetributionService extends IService<Retribution> {

    IPage<RetributionVo> pageInfo(CommonPageableDto pageable, RetributionVo retributionVo);
    
    IPage<RetributionVo> pageCompanyInfo(CommonPageableDto pageable, RetributionVo retributionVo);

    IPage<RewardOrgCodeVo> listPageComcany(StudioPageableDto pageable, String companyName, String orderType);
    
    IPage<RewardOrgCodeVo> listBadPageCompany(StudioPageableDto pageable, RewardOrgCodeVo RewardOrgCodeVo, String orderType);

    IPage<RewardListVo> rewardUserListDetail(StudioPageableDto pageable, RewardListVo rewardVo);

    Integer dayCountByOrgCode(String orgCode, Long projectId);

    Integer dayCompanyCountByOrgCode(String orgCode, Long projectId);
}
