package com.yeejoin.precontrol.common.service.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.dto.StudioPageableDto;
import com.yeejoin.precontrol.common.entity.Reward;
import com.yeejoin.precontrol.common.entity.RewardExchange;
import com.yeejoin.precontrol.common.exception.BaseException;
import com.yeejoin.precontrol.common.mapper.RewardExchangeMapper;
import com.yeejoin.precontrol.common.mapper.RewardMapper;
import com.yeejoin.precontrol.common.service.IRewardExchangeService;
import com.yeejoin.precontrol.common.service.IRewardService;
import com.yeejoin.precontrol.common.vo.RewardExchangeVo;
import com.yeejoin.precontrol.common.vo.RewardExchangeWechatVo;
import com.yeejoin.precontrol.common.vo.RewardListVo;

/**
 * 奖励兑换 服务实现
 *
 * @author wbin
 * @date 2021-04-06
 */
@Service
public class RewardExchangeServiceImpl extends ServiceImpl<RewardExchangeMapper, RewardExchange> implements IRewardExchangeService {

    @Autowired
    private RewardMapper rewardMapper;
    @Autowired
    private RewardExchangeMapper rewardExchangeMapper;
    @Autowired
    private IRewardService iRewardService;


    @Override
    @Transactional
    public boolean saveExchange(RewardExchangeVo rewardExchangeVo) {
        QueryWrapper<Reward> wrapper = new QueryWrapper<>();
        wrapper.in("id", rewardExchangeVo.getIds().split(","));
        List<Reward> rewards = rewardMapper.selectList(wrapper);
        if (rewards.isEmpty()) {
            throw new BaseException("请选择奖励任务!");
        }
        //更新奖励表数据
        List<RewardExchange> rewardExchanges = new ArrayList<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String batchNo = UUID.randomUUID().toString();
        rewards.forEach(w -> {
            w.setStatus(1);//已兑换
            w.setExchangeDate(new Date());
            RewardExchange rewardExchange = new RewardExchange();
            BeanUtils.copyProperties(w, rewardExchange, "id", "createDate");
            rewardExchange.setBatchNo(batchNo);
            rewardExchange.setCreateUserId(rewardExchangeVo.getCreateUserId());
            rewardExchange.setCreateDate(new Date());
            try {
                Date parse = sdf.parse(rewardExchangeVo.getExchangeDate());
                rewardExchange.setExchangeDate(parse);
            } catch (Exception e) {
                e.printStackTrace();
                throw new BaseException("奖励时间转换异常!");
            }
            rewardExchanges.add(rewardExchange);
        });
        iRewardService.updateBatchById(rewards);
        //保存奖励兑换表数据
        this.saveBatch(rewardExchanges);
        return true;
    }

    /**
     * 查询在该日期区间的兑换记录
     *
     * @param startDate 开始日期
     * @param endDate   结束日期
     * @param personId  用户id
     * @return
     */
    @Override
    public List<RewardExchange> reportByUserIdAndBetweenDate(String startDate, String endDate, Long personId) {
        return rewardExchangeMapper.selectReportList(startDate, endDate, personId);
    }

    /**
     * 选择日期的奖励兑换详情
     *
     * @param date
     * @return
     */
    @Override
    public List<RewardExchangeWechatVo> selectByDate(String date, Long personId) {
        return rewardExchangeMapper.selectByDate(date, personId);
    }

    /**
     * 已兑换总金额
     * @param personId
     * @return
     */
    @Override
    public String selectTotalMoney(Long personId) {
        return rewardExchangeMapper.selectTotalMoney(personId);
    }

	@Override
	public IPage<RewardExchangeWechatVo> exchangeRecord(StudioPageableDto pageable,Long personId) {
		if (pageable.getCurrent() == null || pageable.getSize() == null) {
			pageable.setCurrent(0);
			pageable.setSize(Integer.MAX_VALUE);
		}
		Page<RewardExchangeWechatVo> objectPage = new Page<RewardExchangeWechatVo>(pageable.getCurrent(), pageable.getSize());
		return rewardExchangeMapper.exchangeRecord(objectPage,personId);
	}
}
