package com.yeejoin.precontrol.common.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.precontrol.common.dto.BaseDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Description: 违规管理Vo
 * @Author: duanwei
 * @Date: 2020/10/29 
 */
@Data
public class BadCompanyVo extends BaseDto {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "分包商id")
    private Long id;
    @ApiModelProperty(value = "项目id")
    private Long projectId;
    @ApiModelProperty(value = "分包商名称")
    @Excel(name = "分包商名称")
    private String name;
    @Excel(name = "法定代表人")
    private String legalRepresentative;
    @Excel(name = "统一社会信用代码")
    private String creditCode;
    @Excel(name = "企业联系人")
    private String contact;
    @Excel(name = "手机")
    private String phone;
    @Excel(name = "联系电话")
    private String tel;
    @ApiModelProperty(value = "地区")
    @Excel(name = "地区")
    private String region;
    @ApiModelProperty(value = "违章系数")
    @Excel(name = "违章系数")
    private String scale;
    @ApiModelProperty(value = "违章数量")
    @Excel(name = "违章数量")
    private String count;
    @ApiModelProperty(value = "违章系数最小")
    @TableField(exist = false)
    private String minScale;
    @ApiModelProperty(value = "违章系数最大")
    @TableField(exist = false)
    private String maxScale;
    @ApiModelProperty(value = "分包商人数")
    private String personCount;
    @TableField(exist = false)
    @ApiModelProperty(value = "违章数量排序")
    private Boolean countOrder; //false是倒序 true是正序
    @TableField(exist = false)
    @ApiModelProperty(value = "违章系数排序")
    private Boolean scaleOrder; //false是倒序 true是正序
    @ApiModelProperty(value = "处罚金额排序")
    private Boolean moneyOrder; //false是倒序 true是正序
    @ApiModelProperty(value = "处罚金额")
    private BigDecimal money;
    @ApiModelProperty(value = "排序字段")
    private String key;
    @ApiModelProperty(value = "倒叙正序")
    private String sortType;

}
