package com.yeejoin.precontrol.config;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.yeejoin.precontrol.common.utils.RedisUtil;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @description: 处理mybatis业务处理, 新增和更新的基础数据填充，配合BaseEntity和MyBatisPlusConfig使用
 * @author: duanwei
 * @create: 2020-05-28 13:57
 **/
@Component(value = "MetaHandler")
@Primary
public class MetaHandler implements MetaObjectHandler, InitializingBean {

    @Autowired
    RedisUtil redisUtil;

    /**
     * 新增数据拦截
     *
     * @param metaObject
     */
    @Override
    public void insertFill(MetaObject metaObject) {
        Date currentDate = new Date();
        this.setFieldValByName("createDate", currentDate, metaObject);
        this.setFieldValByName("updateTime", currentDate, metaObject);
    }

    /**
     * 更新拦截
     *
     * @param metaObject
     */
    @Override
    public void updateFill(MetaObject metaObject) {
        Date currentDate = new Date();
        this.setFieldValByName("updateTime", currentDate, metaObject);
    }

    @Override
    public void afterPropertiesSet() throws Exception {

    }
}