package com.yeejoin.precontrol.controller;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import com.yeejoin.precontrol.common.entity.publics.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.precontrol.common.service.IProjectDeviceService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.entity.ProjectDevice;
import com.yeejoin.precontrol.common.utils.NameUtils;
import java.lang.reflect.Field;
import java.util.Arrays;


/**
 * 项目设备表
 *
 * @author duanwei
 * @date 2021-03-22
 */
@RestController
@Api(tags = "项目设备表Api")
@RequestMapping(value = "/project-device", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class ProjectDeviceController {

  @Autowired
  IProjectDeviceService iProjectDeviceService;


    /**
    * 新增项目设备表
    * @return
    */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增项目设备表", notes = "新增项目设备表")
    public boolean saveProjectDevice(HttpServletRequest request, @RequestBody ProjectDevice projectDevice){
    return iProjectDeviceService.save(projectDevice);
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
    return iProjectDeviceService.removeById(id);
    }




    /**
    * 修改项目设备表
    * @return
    */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改项目设备表", notes = "修改项目设备表")
    public boolean updateByIdProjectDevice(HttpServletRequest request, @RequestBody ProjectDevice projectDevice){
    return iProjectDeviceService.updateById(projectDevice);
    }



    /**
   * 根据id查询
   * @param id
   * @return
   */
   @RequestMapping(value = "/{id}", method = RequestMethod.GET)
   @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
   public ProjectDevice selectById(HttpServletRequest request, @PathVariable Long id){
      return iProjectDeviceService.getById(id);
   }



  /**
  * 列表分页查询
  * @return
  */
  @RequestMapping(value = "/list", method = RequestMethod.GET)
  @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
  public IPage<ProjectDevice> listPage(String pageNum,String pageSize,
    ProjectDevice projectDevice){

    Page<ProjectDevice> pageBean;
    QueryWrapper<ProjectDevice> projectDeviceQueryWrapper = new QueryWrapper<>();
    Class<? extends ProjectDevice> aClass = projectDevice.getClass();
    Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
        try {
            field.setAccessible(true);
            Object o = field.get(projectDevice);
            if (o != null) {
                Class<?> type = field.getType();
                String name = NameUtils.camel2Underline(field.getName());
                if (type.equals(Integer.class)) {
                Integer fileValue = (Integer) field.get(projectDevice);
                projectDeviceQueryWrapper.eq(name, fileValue);
                } else if (type.equals(Long.class)) {
                Long fileValue = (Long) field.get(projectDevice);
                projectDeviceQueryWrapper.eq(name, fileValue);
                } else if (type.equals(String.class)) {
                String fileValue = (String) field.get(projectDevice);
                projectDeviceQueryWrapper.eq(name, fileValue);
                } else {
                String fileValue = (String) field.get(projectDevice);
                projectDeviceQueryWrapper.eq(name, fileValue);
            }
          }
        }catch (Exception e) {
        }
    });
    IPage<ProjectDevice> page;
    if (StringUtils.isBlank(pageNum)  ||StringUtils.isBlank(pageSize)) {
        pageBean = new Page<>(0, Long.MAX_VALUE);
    }else{
        pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
    }
    page = iProjectDeviceService.page(pageBean, projectDeviceQueryWrapper);
    return page;
  }
}


