package com.yeejoin.precontrol.controller;

import java.util.Arrays;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.entity.ReportStatictisRecord;
import com.yeejoin.precontrol.common.service.IReportStatictisRecordService;
import com.yeejoin.precontrol.common.utils.NameUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 
 *
 * @author duanwei
 * @date 2022-07-01
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/report-statictis-record", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class ReportStatictisRecordController {

	@Autowired
	IReportStatictisRecordService iReportStatictisRecordService;

	/**
	 * 新增
	 * 
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public boolean saveReportStatictisRecord(HttpServletRequest request,
			@RequestBody ReportStatictisRecord reportStatictisRecord) {
		return iReportStatictisRecordService.save(reportStatictisRecord);
	}

	/**
	 * 根据id删除
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
		return iReportStatictisRecordService.removeById(id);
	}

	/**
	 * 修改
	 * 
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
	public boolean updateByIdReportStatictisRecord(HttpServletRequest request,
			@RequestBody ReportStatictisRecord reportStatictisRecord) {
		return iReportStatictisRecordService.updateById(reportStatictisRecord);
	}

	/**
	 * 根据id查询
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public ReportStatictisRecord selectById(HttpServletRequest request, @PathVariable Long id) {
		return iReportStatictisRecordService.getById(id);
	}

	/**
	 * 列表分页查询
	 * 
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<ReportStatictisRecord> listPage(String pageNum, String pageSize,
			ReportStatictisRecord reportStatictisRecord) {

		Page<ReportStatictisRecord> pageBean;
		QueryWrapper<ReportStatictisRecord> reportStatictisRecordQueryWrapper = new QueryWrapper<>();
		Class<? extends ReportStatictisRecord> aClass = reportStatictisRecord.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(reportStatictisRecord);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(reportStatictisRecord);
						reportStatictisRecordQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(reportStatictisRecord);
						reportStatictisRecordQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(reportStatictisRecord);
						reportStatictisRecordQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(reportStatictisRecord);
						reportStatictisRecordQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
			}
		});
		IPage<ReportStatictisRecord> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iReportStatictisRecordService.page(pageBean, reportStatictisRecordQueryWrapper);
		return page;
	}

	@RequestMapping(value = "/record", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "农名工统计", notes = "农名工统计")
	public Object record(HttpServletRequest request, HttpServletResponse response,
			@DateTimeFormat(pattern = "yyyy-MM") Date startMonth, @DateTimeFormat(pattern = "yyyy-MM") Date endMonth,int type) {
		ReportStatictisRecord reportStatictisRecord = iReportStatictisRecordService.getOne(
				new LambdaQueryWrapper<ReportStatictisRecord>().eq(ReportStatictisRecord::getStartMonth, startMonth)
						.eq(ReportStatictisRecord::getStartMonth, startMonth)
						.eq(ReportStatictisRecord::getEndMonth, endMonth).eq(ReportStatictisRecord::getType, type));
		return JSONObject.parse(reportStatictisRecord.getJson());
	}
}
