package com.yeejoin.amos.boot.module.tzs.api.dto;

    import java.util.Date;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
/**
* 特种设备基本信息-使用信息Dto
*
* @author duanwei
* @date 2022-07-26
*/
@Data
public class TzsJgUseInfoDto extends BaseDto {

    private static final long serialVersionUID = 1L;

            @ApiModelProperty(value = "id")
    /**
    * id
    */
    private Long sequenceNbr;
            @ApiModelProperty(value = "设备唯一标识码")
    /**
    * 设备唯一标识码
    */
    private String sequenceCode;
            @ApiModelProperty(value = "监管系统唯一编码")
    /**
    * 监管系统唯一编码
    */
    private String superviseCode;
            @ApiModelProperty(value = "使用单位统一信用代码")
    /**
    * 使用单位统一信用代码
    */
    private String useUnitCreditCode;
            @ApiModelProperty(value = "使用单位名称")
    /**
    * 使用单位名称
    */
    private String useUnitName;
            @ApiModelProperty(value = "产权单位统一信用代码")
    /**
    * 产权单位统一信用代码
    */
    private String estateUnitCreditCode;
            @ApiModelProperty(value = "产权单位名称")
    /**
    * 产权单位名称
    */
    private String estateUnitName;
            @ApiModelProperty(value = "使用状态变更日期")
    /**
    * 使用状态变更日期
    */
    private Date useStateChangeDate;
            @ApiModelProperty(value = "变更事项(使用单位名称变更、变更使用单位、改造/移装变更、延期使用变更)")
    /**
    * 变更事项(使用单位名称变更、变更使用单位、改造/移装变更、延期使用变更)
    */
    private String changes;
            @ApiModelProperty(value = "使用内部编号")
    /**
    * 使用内部编号
    */
    private String useInnerCode;
            @ApiModelProperty(value = "投入使用日期")
    /**
    * 投入使用日期
    */
    private Date useDate;
            
    private String useDateStr;
            @ApiModelProperty(value = "经办人")
    /**
    * 经办人
    */
    private String agent;
            @ApiModelProperty(value = "设备所在地区代码")
    /**
    * 设备所在地区代码
    */
    private String areaCode;
            @ApiModelProperty(value = "设备使用地点_省")
    /**
    * 设备使用地点_省
    */
    private String province;
            @ApiModelProperty(value = "设备使用地点_市")
    /**
    * 设备使用地点_市
    */
    private String city;
            @ApiModelProperty(value = "设备使用地点_区（县）")
    /**
    * 设备使用地点_区（县）
    */
    private String county;
            @ApiModelProperty(value = "设备使用地点_街道（镇）")
    /**
    * 设备使用地点_街道（镇）
    */
    private String street;
            @ApiModelProperty(value = "设备详细使用地址")
    /**
    * 设备详细使用地址
    */
    private String address;
            @ApiModelProperty(value = "设备地理坐标经度")
    /**
    * 设备地理坐标经度
    */
    private String longitude;
            @ApiModelProperty(value = "设备地理坐标纬度")
    /**
    * 设备地理坐标纬度
    */
    private String latitude;
            @ApiModelProperty(value = "设备使用场所(住宅小区、商业单位、学校、医院、政府机关、重要公共场所)")
    /**
    * 设备使用场所(住宅小区、商业单位、学校、医院、政府机关、重要公共场所)
    */
    private String usePlace;
            @ApiModelProperty(value = "设备主管部门(药监局、经信委、文化委、市政市容委、发改委、水务局、住房建设委、交通局、商务委、旅游局、体育局、住房建设委、园林绿化局、水利局、商务委、卫生局、教育局等)")
    /**
    * 设备主管部门(药监局、经信委、文化委、市政市容委、发改委、水务局、住房建设委、交通局、商务委、旅游局、体育局、住房建设委、园林绿化局、水利局、商务委、卫生局、教育局等)
    */
    private String equManageDt;
            @ApiModelProperty(value = "安全管理部门名称")
    /**
    * 安全管理部门名称
    */
    private String safetyManageDt;
            @ApiModelProperty(value = "安全管理员")
    /**
    * 安全管理员
    */
    private String safetyManager;
            @ApiModelProperty(value = "安全管理员移动电话")
    /**
    * 安全管理员移动电话
    */
    private Long phone;
            @ApiModelProperty(value = "设备状态(1在用2停用3报废 4注销5迁出 6拆除 7目录外 8非法设备)")
    /**
    * 设备状态(1在用2停用3报废 4注销5迁出 6拆除 7目录外 8非法设备)
    */
    private String equState;
            @ApiModelProperty(value = "同步时间")
    /**
    * 同步时间
    */
    private Date syncDate;
            @ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
    /**
    * 同步状态（0-新增   1-更新   2-删除）
    */
    private Integer syncState;
            @ApiModelProperty(value = "对接公司编码")
    /**
    * 对接公司编码
    */
    private String appId;
            @ApiModelProperty(value = "创建时间")
    /**
    * 创建时间
    */
    private Date recDate;
            @ApiModelProperty(value = "操作人员")
    /**
    * 操作人员
    */
    private String recUserId;


}
