package com.yeejoin.amos.boot.module.tzs.biz.service.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgBasicInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgConstructionInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgDesignInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgElevatorTechInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgEnclosureInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgInspectionInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgMaintenanceInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgOtherInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgProduceInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgRegistrationInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgSuperviseInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgUseInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.EquipmentCategory;
import com.yeejoin.amos.boot.module.tzs.api.entity.PageParam;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgConstructionInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgDesignInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgElevatorTechInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgEnclosureInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgFile;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgInspectionInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgMaintenanceInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgOtherInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgProduceInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgRegistrationInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgSuperviseInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgUseInfo;
import com.yeejoin.amos.boot.module.tzs.api.enums.JgFileAttributeEnum;
import com.yeejoin.amos.boot.module.tzs.api.enums.JgFileObjectEnum;
import com.yeejoin.amos.boot.module.tzs.api.mapper.TzsJgMapper;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgConstructionInfoService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgDesignInfoService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgElevatorTechInfoService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgEnclosureInfoService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgFileService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgInspectionInfoService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgMaintenanceInfoService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgOtherInfoService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgProduceInfoService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgRegistrationInfoService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgSuperviseInfoService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgUseInfoService;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

@Service
public class TzsJgServiceImpl implements ITzsJgService {

	@Autowired
	TzsJgMapper tzsJgMapper;

	@Autowired
	ITzsJgSuperviseInfoService iTzsJgSuperviseInfoService;

	@Autowired
	ITzsJgDesignInfoService iTzsJgDesignInfoService;

	@Autowired
	ITzsJgProduceInfoService iTzsJgProduceInfoService;

	@Autowired
	ITzsJgRegistrationInfoService iTzsJgRegistrationInfoService;

	@Autowired
	ITzsJgUseInfoService iTzsJgUseInfoService;

	@Autowired
	ITzsJgConstructionInfoService iTzsJgConstructionInfoService;

	@Autowired
	ITzsJgMaintenanceInfoService iTzsJgMaintenanceInfoService;

	@Autowired
	ITzsJgInspectionInfoService iTzsJgInspectionInfoService;

	@Autowired
	ITzsJgElevatorTechInfoService iTzsJgElevatorTechInfoService;

	@Autowired
	ITzsJgOtherInfoService iTzsJgOtherInfoService;

	@Autowired
	ITzsJgFileService iTzsJgFileService;

	@Autowired
	ITzsJgEnclosureInfoService iTzsJgEnclosureInfoService;

	@Autowired
	EquipmentCategoryServiceImpl equipmentCategoryServiceImpl;
	/**
	 * 文件服务器地址
	 */
	@Value("${fileserver.domain}")
	String fileServerUrl;

	@Override
	public IPage<TzsJgBasicInfoDto> page(PageParam pageParam, TzsJgBasicInfoDto tzsJgBasicInfoDto) {
		Set<String> categoryCodes = new HashSet<>();
		if (!ValidationUtil.isEmpty(tzsJgBasicInfoDto.getSuperviseKey()) ) {
			FeignClientResult<CompanyModel> result = Privilege.companyClient
					.seleteOne(Long.valueOf(tzsJgBasicInfoDto.getSuperviseKey()));
			if (result.getResult() != null) {
				tzsJgBasicInfoDto.setOrgBranchCode(result.getResult().getOrgCode());
			}
		}
		if ( !ValidationUtil.isEmpty(tzsJgBasicInfoDto.getEquDefine())    ) {
//			EquipmentCategory equipmentCategory = equipmentCategoryServiceImpl
//					.getOne(new LambdaQueryWrapper<EquipmentCategory>().eq(EquipmentCategory::getId,
//							tzsJgBasicInfoDto.getEquCategory()));
//			if (equipmentCategory != null) {
//				tzsJgBasicInfoDto.setEquCategory(equipmentCategory.getCode().toString().replaceAll("0+$", ""));
			getCategoryCodes(tzsJgBasicInfoDto.getEquDefine(), categoryCodes);
//			}
		}

		Page<TzsJgBasicInfoDto> page = new Page<>(pageParam.getCurrent(), pageParam.getSize());
		tzsJgMapper.page(page, tzsJgBasicInfoDto, categoryCodes);
		for (TzsJgBasicInfoDto basicInfoDto : page.getRecords()) {
			if (ValidationUtil.isEmpty(basicInfoDto.getEquDefine())) {
				LambdaQueryWrapper<EquipmentCategory> wrapper = new LambdaQueryWrapper<>();
				wrapper.eq(EquipmentCategory::getCode, basicInfoDto.getEquCategory());
				basicInfoDto.setEquDefine(equipmentCategoryServiceImpl.getOne(wrapper).getName());
			}
		}
		return page;
	}

	public Set<String> getCategoryCodes(String id, Set<String> categoryCodes) {
		categoryCodes.add(equipmentCategoryServiceImpl.getById(id).getCode());
		LambdaQueryWrapper<EquipmentCategory> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(EquipmentCategory::getParentId, id);
		List<EquipmentCategory> equipmentCategoryList = equipmentCategoryServiceImpl.list(wrapper);
		Iterator<EquipmentCategory> iterator = equipmentCategoryList.iterator();
		while (iterator.hasNext()) {
			getCategoryCodes(String.valueOf(iterator.next().getId()), categoryCodes);
		}
		return null;
	}

	@Override
	public TzsJgBasicInfoDto detail(String code) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		TzsJgBasicInfoDto dto = new TzsJgBasicInfoDto();
		TzsJgSuperviseInfo superviseInfo = iTzsJgSuperviseInfoService
				.getOne(new LambdaQueryWrapper<TzsJgSuperviseInfo>().eq(TzsJgSuperviseInfo::getSequenceCode, code));
		TzsJgSuperviseInfoDto superviseInfoDto = new TzsJgSuperviseInfoDto();
		if (superviseInfo != null) {
			BeanUtils.copyProperties(superviseInfo, superviseInfoDto);
		}
		TzsJgDesignInfo designInfo = iTzsJgDesignInfoService
				.getOne(new LambdaQueryWrapper<TzsJgDesignInfo>().eq(TzsJgDesignInfo::getSequenceCode, code));
		TzsJgDesignInfoDto designInfoDto = new TzsJgDesignInfoDto();
		if (designInfo != null) {
			BeanUtils.copyProperties(designInfo, designInfoDto);
			List<TzsJgFile> designFile = iTzsJgFileService
					.list(new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSquNbr, designInfo.getSequenceNbr())
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.DESIGN_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.DESIGN_FILE.getAttribute()));
			designFile.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			List<TzsJgFile> designCode = iTzsJgFileService
					.list(new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSquNbr, designInfo.getSequenceNbr())
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.DESIGN_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.DESIGN_CODE.getAttribute()));
			designCode.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			designInfoDto.setDesignFile(designFile);
			designInfoDto.setDesignCode(designCode);
		}
		TzsJgProduceInfo produceInfo = iTzsJgProduceInfoService
				.getOne(new LambdaQueryWrapper<TzsJgProduceInfo>().eq(TzsJgProduceInfo::getSequenceCode, code));
		TzsJgProduceInfoDto produceInfoDto = new TzsJgProduceInfoDto();
		if (produceInfo != null) {
			BeanUtils.copyProperties(produceInfo, produceInfoDto);
		    if(produceInfoDto.getProduceDate()!=null) 
		    {
		    	produceInfoDto.setProduceDateStr(sdf.format(produceInfoDto.getProduceDate()));
		    }
			
			List<TzsJgFile> produceStandard = iTzsJgFileService
					.list(new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSquNbr, produceInfo.getSequenceNbr())
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.PRODUCE_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.PRODUCE_STANDARD.getAttribute()));
			List<TzsJgFile> productCertificate = iTzsJgFileService
					.list(new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSquNbr, produceInfo.getSequenceNbr())
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.PRODUCE_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.PRODUCT_CERTIFICATE.getAttribute()));
			List<TzsJgFile> iumInstructions = iTzsJgFileService
					.list(new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSquNbr, produceInfo.getSequenceNbr())
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.PRODUCE_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.IUM_INSTRUCTIONS.getAttribute()));
			List<TzsJgFile> supervisionCert = iTzsJgFileService
					.list(new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSquNbr, produceInfo.getSequenceNbr())
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.PRODUCE_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.SUPERVISION_CERT.getAttribute()));
			List<TzsJgFile> ceCert = iTzsJgFileService
					.list(new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSquNbr, produceInfo.getSequenceNbr())
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.PRODUCE_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.CE_CERT.getAttribute()));
			produceStandard.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			productCertificate.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			iumInstructions.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			supervisionCert.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			ceCert.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			produceInfoDto.setProduceStandard(produceStandard);
			produceInfoDto.setProductCertificate(productCertificate);
			produceInfoDto.setIumInstructions(iumInstructions);
			produceInfoDto.setSupervisionCert(supervisionCert);
			produceInfoDto.setCeCert(ceCert);
		}
		TzsJgRegistrationInfo registrationInfo = iTzsJgRegistrationInfoService.getOne(
				new LambdaQueryWrapper<TzsJgRegistrationInfo>().eq(TzsJgRegistrationInfo::getSequenceCode, code));
		TzsJgRegistrationInfoDto registrationInfoDto = new TzsJgRegistrationInfoDto();
		if (registrationInfo != null) {
			EquipmentCategory define = equipmentCategoryServiceImpl.getOne(new LambdaQueryWrapper<EquipmentCategory>()
					.eq(EquipmentCategory::getCode, registrationInfo.getEquDefine()));
			registrationInfo.setEquDefine(define != null ? define.getName() : null);
			EquipmentCategory category = equipmentCategoryServiceImpl.getOne(new LambdaQueryWrapper<EquipmentCategory>()
					.eq(EquipmentCategory::getCode, registrationInfo.getEquCategory()));
			registrationInfo.setEquCategory(category != null ? category.getName() : null);
			BeanUtils.copyProperties(registrationInfo, registrationInfoDto);
			List<TzsJgFile> useRegistCertificate = iTzsJgFileService.list(new LambdaQueryWrapper<TzsJgFile>()
					.eq(TzsJgFile::getSquNbr, registrationInfo.getSequenceNbr())
					.eq(TzsJgFile::getObjectType, JgFileObjectEnum.REGISTRATION_INFO.getObject())
					.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.USE_REGIST_CERTIFICATE.getAttribute()));
			useRegistCertificate.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			registrationInfoDto.setUseRegistCertificate(useRegistCertificate);
		}
		TzsJgUseInfo useInfo = iTzsJgUseInfoService
				.getOne(new LambdaQueryWrapper<TzsJgUseInfo>().eq(TzsJgUseInfo::getSequenceCode, code));
		TzsJgUseInfoDto useInfoDto = new TzsJgUseInfoDto();
		if (useInfo != null) {
			BeanUtils.copyProperties(useInfo, useInfoDto);
			if(useInfoDto.getUseDate()!=null) 
			{
				useInfoDto.setUseDateStr(sdf.format(useInfoDto.getUseDate()));
			}
			
		}
		TzsJgConstructionInfo constructionInfo = iTzsJgConstructionInfoService
				.getOne(new LambdaQueryWrapper<TzsJgConstructionInfo>().eq(TzsJgConstructionInfo::getSequenceCode, code)
						.orderByDesc(TzsJgConstructionInfo::getRecDate).last("limit 1"));
		TzsJgConstructionInfoDto constructionInfoDto = new TzsJgConstructionInfoDto();
		if (constructionInfo != null) {
			BeanUtils.copyProperties(constructionInfo, constructionInfoDto);
		}

		List<TzsJgConstructionInfo> constructionInfoList = iTzsJgConstructionInfoService
				.list(new LambdaQueryWrapper<TzsJgConstructionInfo>().eq(TzsJgConstructionInfo::getSequenceCode, code));
		List<TzsJgConstructionInfoDto> constructionInfoDtoList = new ArrayList<>();
		if (!constructionInfoList.isEmpty()) {
			for (TzsJgConstructionInfo constructionInfoOne : constructionInfoList) {
				TzsJgConstructionInfoDto constructionInfoDtoOne = new TzsJgConstructionInfoDto();
				BeanUtils.copyProperties(constructionInfoOne, constructionInfoDtoOne);
				if(constructionInfoDtoOne.getUscDate()!=null) 
				{
					constructionInfoDtoOne.setUscDateStr(sdf.format(constructionInfoDtoOne.getUscDate()));
				}			
				constructionInfoDtoList.add(constructionInfoDtoOne);
			}
		}

		TzsJgMaintenanceInfo maintenanceInfo = iTzsJgMaintenanceInfoService
				.getOne(new LambdaQueryWrapper<TzsJgMaintenanceInfo>().eq(TzsJgMaintenanceInfo::getSequenceCode, code)
						.orderByDesc(TzsJgMaintenanceInfo::getRecDate).last("limit 1"));
		TzsJgMaintenanceInfoDto maintenanceInfoDto = new TzsJgMaintenanceInfoDto();
		if (maintenanceInfo != null) {
			BeanUtils.copyProperties(maintenanceInfo, maintenanceInfoDto);
			List<TzsJgFile> repairInform = iTzsJgFileService
					.list(new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSquNbr, maintenanceInfo.getSequenceNbr())
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.MAINTENANCE_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.REPAIR_INFORM.getAttribute()));
			repairInform.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			maintenanceInfoDto.setRepairInform(repairInform);
		}

		List<TzsJgMaintenanceInfo> maintenanceInfoList = iTzsJgMaintenanceInfoService
				.list(new LambdaQueryWrapper<TzsJgMaintenanceInfo>().eq(TzsJgMaintenanceInfo::getSequenceCode, code));
		List<TzsJgMaintenanceInfoDto> maintenanceInfoDtoList = new ArrayList<>();
		if (!maintenanceInfoList.isEmpty()) {
			for (TzsJgMaintenanceInfo maintenanceInfoOne : maintenanceInfoList) {
				TzsJgMaintenanceInfoDto maintenanceInfoDtoOne = new TzsJgMaintenanceInfoDto();
				BeanUtils.copyProperties(maintenanceInfoOne, maintenanceInfoDtoOne);
				List<TzsJgFile> repairInform = iTzsJgFileService.list(new LambdaQueryWrapper<TzsJgFile>()
						.eq(TzsJgFile::getSquNbr, maintenanceInfoOne.getSequenceNbr())
						.eq(TzsJgFile::getObjectType, JgFileObjectEnum.MAINTENANCE_INFO.getObject())
						.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.REPAIR_INFORM.getAttribute()));
				repairInform.forEach(e -> e.setFileUrl(fileServerUrl + e.getFileUrl()));
				maintenanceInfoDtoOne.setRepairInform(repairInform);
				if(maintenanceInfoDtoOne.getInformStart()!=null) {
					maintenanceInfoDtoOne.setInformStartStr(sdf.format(maintenanceInfoDtoOne.getInformStart()));
				}
				if(maintenanceInfoDtoOne.getInformEnd()!=null) {
				maintenanceInfoDtoOne.setInformEndStr(sdf.format(maintenanceInfoDtoOne.getInformEnd()));
				}
				maintenanceInfoDtoList.add(maintenanceInfoDtoOne);
			}
		}

		TzsJgInspectionInfo inspectionInfo = iTzsJgInspectionInfoService
				.getOne(new LambdaQueryWrapper<TzsJgInspectionInfo>().eq(TzsJgInspectionInfo::getSequenceCode, code)
						.orderByDesc(TzsJgInspectionInfo::getRecDate).last("limit 1"));
		TzsJgInspectionInfoDto inspectionInfoDto = new TzsJgInspectionInfoDto();
		if (inspectionInfo != null) {
			BeanUtils.copyProperties(inspectionInfo, inspectionInfoDto);
			List<TzsJgFile> inspectionReport = iTzsJgFileService
					.list(new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSquNbr, inspectionInfo.getSequenceNbr())
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.INSPECTION_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.INSPECTION_REPORT.getAttribute()));
			inspectionReport.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			inspectionInfoDto.setInspectionReport(inspectionReport);
		}

		List<TzsJgInspectionInfo> inspectionInfoList = iTzsJgInspectionInfoService
				.list(new LambdaQueryWrapper<TzsJgInspectionInfo>().eq(TzsJgInspectionInfo::getSequenceCode, code));
		List<TzsJgInspectionInfoDto> inspectionInfoDtoList = new ArrayList<>();
		if (!inspectionInfoList.isEmpty()) {
			for (TzsJgInspectionInfo inspectionInfoOne : inspectionInfoList) {
				TzsJgInspectionInfoDto inspectionInfoDtoOne = new TzsJgInspectionInfoDto();
				BeanUtils.copyProperties(inspectionInfoOne, inspectionInfoDtoOne);
				List<TzsJgFile> repairInform = iTzsJgFileService.list(
						new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSquNbr, inspectionInfoOne.getSequenceNbr())
								.eq(TzsJgFile::getObjectType, JgFileObjectEnum.INSPECTION_INFO.getObject())
								.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.INSPECTION_REPORT.getAttribute()));
				repairInform.forEach(e -> e.setFileUrl(fileServerUrl + e.getFileUrl()));
				inspectionInfoDtoOne.setInspectionReport(repairInform);
				if(inspectionInfoDtoOne.getInspectDate()!=null) 
				{
					inspectionInfoDtoOne.setInspectDateStr(sdf.format(inspectionInfoDtoOne.getInspectDate()));
				}
				if(inspectionInfoDtoOne.getNextInspectDate()!=null) {
					
					inspectionInfoDtoOne.setNextInspectDateStr(sdf.format(inspectionInfoDtoOne.getNextInspectDate()));
				}
				inspectionInfoDtoList.add(inspectionInfoDtoOne);
			}
		}

		TzsJgOtherInfo otherInfo = iTzsJgOtherInfoService
				.getOne(new LambdaQueryWrapper<TzsJgOtherInfo>().eq(TzsJgOtherInfo::getSequenceCode, code));
		TzsJgOtherInfoDto otherInfoDto = new TzsJgOtherInfoDto();
		if (otherInfo != null) {
			BeanUtils.copyProperties(otherInfo, otherInfoDto);
			if(otherInfoDto.getExpiryDate()!=null) {
				otherInfoDto.setExpiryDateStr(sdf.format(otherInfoDto.getExpiryDate()));
			}
			
		}
		TzsJgElevatorTechInfo elevatorTechInfo = iTzsJgElevatorTechInfoService.getOne(
				new LambdaQueryWrapper<TzsJgElevatorTechInfo>().eq(TzsJgElevatorTechInfo::getSequenceCode, code));
		TzsJgElevatorTechInfoDto elevatorTechInfoDto = new TzsJgElevatorTechInfoDto();
		if (elevatorTechInfo != null) {
			BeanUtils.copyProperties(elevatorTechInfo, elevatorTechInfoDto);
			List<TzsJgFile> governorEffiReport = iTzsJgFileService.list(
					new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSquNbr, elevatorTechInfo.getSequenceNbr())
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.ELEVATOR_TECH_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.GOVERNOR_EFFI_REPORT.getAttribute()));
			governorEffiReport.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			elevatorTechInfoDto.setGovernorEffiReport(governorEffiReport);
		}

		List<TzsJgEnclosureInfo> enclosureInfoList = iTzsJgEnclosureInfoService
				.list(new LambdaQueryWrapper<TzsJgEnclosureInfo>().eq(TzsJgEnclosureInfo::getSequenceCode, code));
		List<TzsJgEnclosureInfoDto> enclosureInfoDtoList = new ArrayList<TzsJgEnclosureInfoDto>();
		if (!enclosureInfoList.isEmpty()) {
			for (TzsJgEnclosureInfo enclosureInfo : enclosureInfoList) {
				TzsJgEnclosureInfoDto enclosureInfoDtoOne = new TzsJgEnclosureInfoDto();
				BeanUtils.copyProperties(enclosureInfo, enclosureInfoDtoOne);
				// repairInform.forEach(e -> e.setFileUrl(fileServerUrl + e.getFileUrl()));
				enclosureInfoDtoList.add(enclosureInfoDtoOne);
			}
		}

		dto.setSequenceCode(code);
		if (superviseInfo != null) {
			dto.setSuperviseCode(superviseInfo.getSuperviseCode());
			dto.setOrgBranchName(superviseInfo.getOrgBranchName());
		}
		if (useInfo != null) {
			dto.setUseUnitName(useInfo.getUseUnitName());
			dto.setEstateUnitName(useInfo.getEstateUnitName());
			dto.setArea(useInfo.getProvince() + "/" + useInfo.getCity() + "/" + useInfo.getCounty());
			dto.setAddress(useInfo.getAddress());
		}
		if (maintenanceInfo != null) {
			dto.setMeUnitName(maintenanceInfo.getMeUnitName());
		}
		if (registrationInfo != null) {
			dto.setEquCode(registrationInfo.getEquCode());
			dto.setEquDefine(registrationInfo.getEquDefine());
			dto.setEquCategory(registrationInfo.getEquCategory());
			dto.setUseOrgCode(registrationInfo.getUseOrgCode());
		}
		if (otherInfo != null) {
			dto.setCode96333(otherInfo.getCode96333());
		}
		if (produceInfo != null) {
			dto.setFactoryNum(produceInfo.getFactoryNum());
		}
		dto.setSuperviseInfo(superviseInfoDto);
		dto.setDesignInfo(designInfoDto);
		dto.setProduceInfo(produceInfoDto);
		dto.setRegistrationInfo(registrationInfoDto);
		dto.setUseInfo(useInfoDto);
		dto.setElevatorTechInfo(elevatorTechInfoDto);
		dto.setConstructionInfo(constructionInfoDto);
		dto.setConstructionInfoList(constructionInfoDtoList);
		dto.setMaintenanceInfo(maintenanceInfoDto);
		dto.setMaintenanceInfoList(maintenanceInfoDtoList);
		dto.setInspectionInfo(inspectionInfoDto);
		dto.setInspectionInfoList(inspectionInfoDtoList);
		dto.setEnclousureInfo(enclosureInfoDtoList);
		dto.setOtherInfo(otherInfoDto);
		return dto;
	}

}
